/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GenericUpstreamSurfacelessHook;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import com.jogamp.opengl.egl.EGL;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDummyUpstreamSurfaceHook;
import jogamp.opengl.egl.EGLES1DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLES2DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLExternalContext;
import jogamp.opengl.egl.EGLGLnDynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLSurface;

public class EGLDrawableFactory
extends GLDrawableFactoryImpl {
    protected static final boolean DEBUG = GLDrawableFactoryImpl.DEBUG;
    private static final boolean DEBUG_SHAREDCTX = DEBUG || GLContext.DEBUG;
    private static boolean eglDynamicLookupHelperInit;
    private static GLDynamicLookupHelper eglES1DynamicLookupHelper;
    private static GLDynamicLookupHelper eglES2DynamicLookupHelper;
    private static GLDynamicLookupHelper eglGLnDynamicLookupHelper;
    private static boolean isANGLE;
    private static boolean hasX11;
    private static String defaultConnection;
    private static EGLGraphicsDevice defaultDevice;
    private static EGLFeatures defaultDeviceEGLFeatures;
    private static SharedResource defaultSharedResource;
    static final String eglInitializeFuncName = "eglInitialize";
    private SharedResourceImplementation sharedResourceImplementation;
    private SharedResourceRunner sharedResourceRunner;

    private static final boolean isANGLE(GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (Platform.OSType.WINDOWS == PlatformPropsImpl.OS_TYPE) {
            return gLDynamicLookupHelper.isFunctionAvailable("eglQuerySurfacePointerANGLE") || gLDynamicLookupHelper.isFunctionAvailable("glBlitFramebufferANGLE") || gLDynamicLookupHelper.isFunctionAvailable("glRenderbufferStorageMultisampleANGLE");
        }
        return false;
    }

    private static final boolean includesES1(GLDynamicLookupHelper gLDynamicLookupHelper) {
        return gLDynamicLookupHelper.isFunctionAvailable("glLoadIdentity") && gLDynamicLookupHelper.isFunctionAvailable("glEnableClientState") && gLDynamicLookupHelper.isFunctionAvailable("glColorPointer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EGLDrawableFactory() {
        Class<EGLDrawableFactory> clazz = EGLDrawableFactory.class;
        synchronized (EGLDrawableFactory.class) {
            GLDynamicLookupHelper gLDynamicLookupHelper;
            long l;
            boolean bl;
            block52: {
                if (eglDynamicLookupHelperInit) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                eglDynamicLookupHelperInit = true;
                String string = NativeWindowFactory.getNativeWindowType(true);
                if (NativeWindowFactory.TYPE_X11 == string) {
                    hasX11 = true;
                    try {
                        ReflectionUtil.createInstance((String)"jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory", (ClassLoader)EGLDrawableFactory.class.getClassLoader());
                    }
                    catch (Exception exception) {}
                } else {
                    hasX11 = false;
                }
                defaultConnection = NativeWindowFactory.getDefaultDisplayConnection(string);
                bl = false;
                l = 0L;
                gLDynamicLookupHelper = null;
                try {
                    gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES2DynamicLibraryBundleInfo());
                }
                catch (GLException gLException) {
                    if (!DEBUG) break block52;
                    gLException.printStackTrace();
                }
            }
            if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete() && (bl = EGLAcc.resetProcAddressTable((DynamicLookupHelper)gLDynamicLookupHelper))) {
                boolean bl2;
                l = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                eglES2DynamicLookupHelper = gLDynamicLookupHelper;
                boolean bl3 = bl2 = null == eglES1DynamicLookupHelper && EGLDrawableFactory.includesES1(eglES2DynamicLookupHelper);
                if (bl2) {
                    eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                }
                boolean bl4 = EGLDrawableFactory.isANGLE(eglES2DynamicLookupHelper);
                isANGLE |= bl4;
                if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES2 - OK (includesES1 " + bl2 + ", isANGLE: " + bl4 + ", eglInitialize 0x" + Long.toHexString(l) + ")");
                    if (bl2) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK (ES2 lib)");
                    }
                }
            } else if (DEBUG || GLProfile.DEBUG) {
                System.err.println("Info: EGLDrawableFactory: EGL ES2 - NOPE");
            }
            if (null == eglES1DynamicLookupHelper) {
                block53: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES1DynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block53;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    boolean bl5;
                    long l2;
                    if (!bl) {
                        bl = EGLAcc.resetProcAddressTable((DynamicLookupHelper)gLDynamicLookupHelper);
                        if (bl) {
                            l = l2 = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                            bl5 = true;
                        } else {
                            l2 = 0L;
                            bl5 = false;
                        }
                    } else {
                        l2 = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                        boolean bl6 = bl5 = l2 == l;
                    }
                    if (bl5) {
                        eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                        boolean bl7 = EGLDrawableFactory.isANGLE(eglES1DynamicLookupHelper);
                        isANGLE |= bl7;
                        if (DEBUG || GLProfile.DEBUG) {
                            System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK (isANGLE: " + bl7 + ", eglTableReset " + bl + ", eglInitialize 0x" + Long.toHexString(l2) + ")");
                        }
                    } else if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES1 - NOPE (ES1 proc, eglTableReset " + bl + ", eglInitialize 0x" + Long.toHexString(l2) + ")");
                    }
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES1 - NOPE (ES1 lib)");
                }
            }
            if (null == eglGLnDynamicLookupHelper) {
                if (!GLProfile.disableOpenGLDesktop) {
                    block54: {
                        gLDynamicLookupHelper = null;
                        try {
                            gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLGLnDynamicLibraryBundleInfo());
                        }
                        catch (GLException gLException) {
                            if (!DEBUG) break block54;
                            gLException.printStackTrace();
                        }
                    }
                    if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                        boolean bl8;
                        long l3;
                        if (!bl) {
                            bl = EGLAcc.resetProcAddressTable((DynamicLookupHelper)gLDynamicLookupHelper);
                            if (bl) {
                                l = l3 = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                                bl8 = true;
                            } else {
                                l3 = 0L;
                                bl8 = false;
                            }
                        } else {
                            l3 = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                            boolean bl9 = bl8 = l3 == l;
                        }
                        if (bl8) {
                            eglGLnDynamicLookupHelper = gLDynamicLookupHelper;
                            if (DEBUG || GLProfile.DEBUG) {
                                System.err.println("Info: EGLDrawableFactory: EGL GLn - OK (eglTableReset " + bl + ", eglInitialize 0x" + Long.toHexString(l3) + ")");
                            }
                        } else if (DEBUG || GLProfile.DEBUG) {
                            System.err.println("Info: EGLDrawableFactory: EGL GLn - NOPE (GLn proc, eglTableReset " + bl + ", eglInitialize 0x" + Long.toHexString(l3) + ")");
                        }
                    } else if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL GLn - NOPE (GLn lib)");
                    }
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL Gln - disabled!");
                }
            }
            if (null != eglES2DynamicLookupHelper || null != eglES1DynamicLookupHelper || null != eglGLnDynamicLookupHelper) {
                if (isANGLE && !GLProfile.enableANGLE) {
                    if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory.init - EGL/ES2 ANGLE disabled");
                    }
                } else {
                    if (isANGLE && (DEBUG || GLProfile.DEBUG)) {
                        System.err.println("Info: EGLDrawableFactory.init - EGL/ES2 ANGLE enabled");
                    }
                    EGLGraphicsConfigurationFactory.registerFactory();
                    defaultDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(0L, defaultConnection, 0);
                    this.sharedResourceImplementation = new SharedResourceImplementation();
                    this.sharedResourceRunner = new SharedResourceRunner(this.sharedResourceImplementation);
                    this.sharedResourceRunner.start();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected final boolean isComplete() {
        return null != this.sharedResourceImplementation;
    }

    @Override
    protected final void shutdownImpl() {
        if (DEBUG) {
            System.err.println("EGLDrawableFactory.shutdown");
        }
        if (null != this.sharedResourceRunner) {
            this.sharedResourceRunner.stop();
            this.sharedResourceRunner = null;
        }
        if (null != this.sharedResourceImplementation) {
            this.sharedResourceImplementation.clear();
            this.sharedResourceImplementation = null;
        }
        if (null != defaultDevice) {
            defaultDevice.close();
            defaultDevice = null;
        }
        if (null != eglES1DynamicLookupHelper) {
            eglES1DynamicLookupHelper = null;
        }
        if (null != eglES2DynamicLookupHelper) {
            eglES2DynamicLookupHelper = null;
        }
        if (null != eglGLnDynamicLookupHelper) {
            eglGLnDynamicLookupHelper = null;
        }
        EGLGraphicsConfigurationFactory.unregisterFactory();
        EGLDisplayUtil.shutdown(DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMap() {
        SharedResourceImplementation sharedResourceImplementation = this.sharedResourceImplementation;
        synchronized (sharedResourceImplementation) {
            Map<String, SharedResourceRunner.Resource> map = this.sharedResourceImplementation.getSharedMap();
            System.err.println("EGLDrawableFactory.MapGLVersion.map " + map.size());
            int n = 0;
            Set<String> set = map.keySet();
            for (String string : set) {
                SharedResource sharedResource = (SharedResource)map.get(string);
                System.err.println("EGLDrawableFactory.MapGLVersion.map[" + n + "] " + string + " -> " + sharedResource.getDevice() + ", avail " + sharedResource.isAvailable + ", es1 [avail " + sharedResource.isAvailableES1 + ", quirks " + sharedResource.rendererQuirksES1 + ", ctp " + EGLContext.getGLVersion(1, 0, sharedResource.ctpES1, null) + "], es2 [avail " + sharedResource.isAvailableES2 + ", quirks " + sharedResource.rendererQuirksES2 + ", ctp " + EGLContext.getGLVersion(2, 0, sharedResource.ctpES2, null) + "], es3 [avail " + sharedResource.isAvailableES3 + ", quirks " + sharedResource.rendererQuirksES3 + ", ctp " + EGLContext.getGLVersion(2, 0, sharedResource.ctpES3, null) + "], gln [avail " + sharedResource.isAvailableGLn + ", quirks " + sharedResource.rendererQuirksGLn + ", ctp " + EGLContext.getGLVersion(3, 0, sharedResource.ctpGLn, null) + "]");
                ++n;
            }
        }
    }

    public final boolean hasDefaultDeviceKHRCreateContext() {
        return EGLDrawableFactory.defaultDeviceEGLFeatures.hasKHRCreateContext;
    }

    @Override
    public final boolean hasOpenGLDesktopSupport() {
        return null != eglGLnDynamicLookupHelper && EGLDrawableFactory.defaultDeviceEGLFeatures.hasGLAPI && EGLDrawableFactory.defaultDeviceEGLFeatures.hasKHRCreateContext;
    }

    @Override
    public final boolean hasOpenGLESSupport() {
        return true;
    }

    @Override
    public final boolean hasMajorMinorCreateContextARB() {
        return this.hasDefaultDeviceKHRCreateContext();
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != this.sharedResourceImplementation;
    }

    private static List<GLCapabilitiesImmutable> getAvailableEGLConfigs(EGLGraphicsDevice eGLGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigs(eGLGraphicsDevice.getHandle(), null, 0, intBuffer)) {
            throw new GLException("EGLDrawableFactory.getAvailableEGLConfigs: Get maxConfigs (eglGetConfigs) call failed, error " + EGLContext.toHexString(EGL.eglGetError()));
        }
        if (0 < intBuffer.get(0)) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)intBuffer.get(0));
            IntBuffer intBuffer2 = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable);
            int n = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
            if (EGL.eglChooseConfig(eGLGraphicsDevice.getHandle(), intBuffer2, pointerBuffer, pointerBuffer.capacity(), intBuffer) && intBuffer.get(0) > 0) {
                return EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLCapabilitiesImmutable.getGLProfile(), pointerBuffer, intBuffer.get(0), n, false, false);
            }
        }
        return new ArrayList<GLCapabilitiesImmutable>(0);
    }

    static void dumpEGLInfo(String string, long l) {
        String string2 = EGL.eglQueryString(l, 12371);
        String string3 = EGL.eglQueryString(l, 12429);
        String string4 = EGL.eglQueryString(0L, 12372);
        String string5 = EGL.eglQueryString(l, 12372);
        System.err.println(string + "EGL vendor " + string2 + ", version [client " + string4 + ", server " + string5 + "], clientAPIs " + string3);
    }

    @Override
    protected final SharedResource getOrCreateSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return this.sharedResourceRunner.start();
    }

    public final boolean isANGLE() {
        return isANGLE;
    }

    @Override
    public final GLDynamicLookupHelper getGLDynamicLookupHelper(int n, int n2) {
        GLDynamicLookupHelper gLDynamicLookupHelper;
        if (EGLContext.isGLES2ES3(n, n2)) {
            gLDynamicLookupHelper = eglES2DynamicLookupHelper;
        } else if (EGLContext.isGLES1(n, n2)) {
            gLDynamicLookupHelper = eglES1DynamicLookupHelper;
        } else if (EGLContext.isGLDesktop(n2)) {
            gLDynamicLookupHelper = eglGLnDynamicLookupHelper;
        } else {
            throw new IllegalArgumentException("neither GLES1, GLES2, GLES3 nor desktop GL has been specified: " + n + " (" + EGLContext.getGLProfile(new StringBuilder(), n2).toString());
        }
        if (DEBUG_SHAREDCTX && null == gLDynamicLookupHelper) {
            System.err.println("EGLDrawableFactory.getGLDynamicLookupHelper: NULL for profile " + n + " (" + EGLContext.getGLProfile(new StringBuilder(), n2).toString());
        }
        return gLDynamicLookupHelper;
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == this.sharedResourceImplementation) {
            return new ArrayList<GLCapabilitiesImmutable>();
        }
        return EGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new EGLDrawable(this, EGLSurface.get(nativeSurface));
    }

    @Override
    protected GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new GLException("Non pbuffer not yet implemented");
        }
        return new EGLDrawable(this, EGLSurface.get(nativeSurface));
    }

    @Override
    public boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        return true;
    }

    private final EGLGraphicsConfiguration evalConfig(boolean[] blArray, AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        EGLGraphicsDevice eGLGraphicsDevice;
        if (bl || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(abstractGraphicsDevice);
            eGLGraphicsDevice.open();
            blArray[0] = true;
        } else {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
            blArray[0] = false;
        }
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, 0);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        if (null == eGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return eGLGraphicsConfiguration;
    }

    @Override
    protected final EGLSurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        boolean[] blArray = new boolean[]{false};
        EGLGraphicsConfiguration eGLGraphicsConfiguration = this.evalConfig(blArray, abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
        return EGLSurface.createWrapped(eGLGraphicsConfiguration, 0L, upstreamSurfaceHook, blArray[0]);
    }

    @Override
    public final EGLSurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilitiesImmutable);
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, new EGLDummyUpstreamSurfaceHook(n, n2));
    }

    @Override
    public final EGLSurface createSurfacelessImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
        boolean[] blArray = new boolean[]{false};
        EGLGraphicsConfiguration eGLGraphicsConfiguration = this.evalConfig(blArray, abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
        return EGLSurface.createSurfaceless(eGLGraphicsConfiguration, new GenericUpstreamSurfacelessHook(n, n2), blArray[0]);
    }

    protected static MutableSurface createPBufferSurfaceImpl(MutableSurface mutableSurface, boolean bl) {
        return null;
    }

    protected static long createPBufferSurfaceImpl(EGLGraphicsConfiguration eGLGraphicsConfiguration, int n, int n2, boolean bl) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities();
        int n3 = bl ? (gLCapabilitiesImmutable.getAlphaBits() > 0 ? 12382 : 12381) : 12380;
        if (DEBUG) {
            System.out.println("Pbuffer config: " + eGLGraphicsConfiguration);
        }
        IntBuffer intBuffer = EGLGraphicsConfiguration.CreatePBufferSurfaceAttribList(n, n2, n3);
        long l = EGL.eglCreatePbufferSurface(eGLGraphicsDevice.getHandle(), eGLGraphicsConfiguration.getNativeConfig(), intBuffer);
        if (0L == l) {
            throw new GLException("Creation of window surface (eglCreatePbufferSurface) failed, dim " + n + "x" + n2 + ", " + eGLGraphicsDevice + ", " + eGLGraphicsConfiguration + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("PBuffer setSurface result: eglSurface 0x" + Long.toHexString(l));
        }
        return l;
    }

    @Override
    protected EGLSurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        EGLGraphicsDevice eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(abstractGraphicsDevice);
        eGLGraphicsDevice.open();
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, n);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        return EGLSurface.createWrapped(eGLGraphicsConfiguration, l, upstreamSurfaceHook, true);
    }

    @Override
    protected GLContext createExternalGLContextImpl() {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault(NativeWindowFactory.TYPE_EGL);
        return new EGLExternalContext(abstractGraphicsScreen);
    }

    @Override
    public boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    protected GLDrawable createExternalGLDrawableImpl() {
        throw new GLException("Not yet implemented");
    }

    static {
        Debug.initSingleton();
        eglDynamicLookupHelperInit = false;
        eglES1DynamicLookupHelper = null;
        eglES2DynamicLookupHelper = null;
        eglGLnDynamicLookupHelper = null;
        isANGLE = false;
        hasX11 = false;
        defaultConnection = null;
        defaultDevice = null;
        defaultDeviceEGLFeatures = null;
        defaultSharedResource = null;
    }

    class SharedResourceImplementation
    extends SharedResourceRunner.AImplementation {
        SharedResourceImplementation() {
        }

        @Override
        public boolean isDeviceSupported(AbstractGraphicsDevice abstractGraphicsDevice) {
            return null != EGLDrawableFactory.this.sharedResourceImplementation;
        }

        @Override
        public SharedResourceRunner.Resource createSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
            abstractGraphicsDevice.lock();
            try {
                SharedResource sharedResource = this.createEGLSharedResourceImpl(abstractGraphicsDevice);
                return sharedResource;
            }
            catch (Throwable throwable) {
                throw new GLException("EGLGLXDrawableFactory - Could not initialize shared resources for " + abstractGraphicsDevice, throwable);
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SharedResource createEGLSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
            SharedResource sharedResource;
            boolean bl;
            boolean bl2;
            if (DEBUG_SHAREDCTX) {
                System.err.println("EGLDrawableFactory.MapGLVersions: device " + abstractGraphicsDevice);
            }
            if (0L == defaultDevice.getHandle()) {
                boolean bl3;
                boolean bl4;
                bl2 = true;
                defaultDevice.open();
                defaultDeviceEGLFeatures = new EGLFeatures(defaultDevice);
                if (DEBUG_SHAREDCTX) {
                    System.err.println("EGLDrawableFactory.MapGLVersions: defaultDevice " + defaultDevice);
                    System.err.println("EGLDrawableFactory.MapGLVersions: defaultDevice EGLFeatures " + defaultDeviceEGLFeatures);
                }
                if (defaultDeviceEGLFeatures.vendor.contains("NVIDIA")) {
                    bl4 = true;
                    bl3 = false;
                } else {
                    bl4 = false;
                    long l = EGL.eglGetDisplay(0L);
                    boolean bl5 = bl3 = 0L == l;
                }
                if (bl4 || bl3) {
                    GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, 16);
                    EGLDisplayUtil.setSingletonEGLDisplayOnly(true);
                    if (DEBUG_SHAREDCTX) {
                        if (bl4) {
                            System.err.println("Quirk: " + GLRendererQuirks.toString(16) + ": cause: Vendor: " + defaultDeviceEGLFeatures);
                        } else if (bl3) {
                            System.err.println("Quirk: " + GLRendererQuirks.toString(16) + ": cause: Second eglGetDisplay(EGL_DEFAULT_DISPLAY) failed");
                        }
                    }
                }
            } else {
                bl2 = false;
                if (null == defaultSharedResource) {
                    throw new InternalError("XXX: defaultDevice " + defaultDevice + ", adevice " + abstractGraphicsDevice);
                }
            }
            boolean[] blArray = new boolean[]{false};
            final GLRendererQuirks[] gLRendererQuirksArray = new GLRendererQuirks[]{null};
            final GLRendererQuirks[] gLRendererQuirksArray2 = new GLRendererQuirks[]{null};
            final GLRendererQuirks[] gLRendererQuirksArray3 = new GLRendererQuirks[]{null};
            final GLRendererQuirks[] gLRendererQuirksArray4 = new GLRendererQuirks[]{null};
            final int[] nArray = new int[]{0};
            final int[] nArray2 = new int[]{0};
            final int[] nArray3 = new int[]{0};
            final int[] nArray4 = new int[]{0};
            final boolean[] blArray2 = new boolean[]{false};
            final boolean[] blArray3 = new boolean[]{false};
            final boolean[] blArray4 = new boolean[]{false};
            final boolean[] blArray5 = new boolean[]{false};
            GLContextImpl.MappedGLVersionListener mappedGLVersionListener = new GLContextImpl.MappedGLVersionListener(){

                @Override
                public void glVersionMapped(GLContextImpl.MappedGLVersion mappedGLVersion) {
                    if (DEBUG_SHAREDCTX) {
                        System.err.println("EGLDrawableFactory.MapGLVersions: Mapped: " + mappedGLVersion);
                    }
                    if (EGLContext.isGLES2ES3(mappedGLVersion.ctxVersion.getMajor(), mappedGLVersion.ctxOptions)) {
                        if (mappedGLVersion.ctxVersion.getMajor() == 3) {
                            blArray4[0] = true;
                            gLRendererQuirksArray3[0] = mappedGLVersion.quirks;
                            nArray3[0] = mappedGLVersion.ctxOptions;
                        }
                        blArray3[0] = true;
                        gLRendererQuirksArray2[0] = mappedGLVersion.quirks;
                        nArray2[0] = mappedGLVersion.ctxOptions;
                    } else if (EGLContext.isGLES1(mappedGLVersion.ctxVersion.getMajor(), mappedGLVersion.ctxOptions)) {
                        blArray2[0] = true;
                        gLRendererQuirksArray[0] = mappedGLVersion.quirks;
                        nArray[0] = mappedGLVersion.ctxOptions;
                    } else if (EGLContext.isGLDesktop(mappedGLVersion.ctxOptions)) {
                        blArray5[0] = true;
                        gLRendererQuirksArray4[0] = mappedGLVersion.quirks;
                        nArray4[0] = mappedGLVersion.ctxOptions;
                    }
                }
            };
            EGLGraphicsDevice[] eGLGraphicsDeviceArray = new EGLGraphicsDevice[]{null};
            EGLContext.setMappedGLVersionListener(mappedGLVersionListener);
            try {
                bl = this.mapAvailableEGLESConfig(abstractGraphicsDevice, blArray, eGLGraphicsDeviceArray);
            }
            finally {
                EGLContext.setMappedGLVersionListener(null);
            }
            if (blArray[0]) {
                EGLContext.remapAvailableGLVersions(defaultDevice, abstractGraphicsDevice);
                sharedResource = defaultSharedResource;
            } else {
                if (hasX11) {
                    this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray[0]);
                    this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray4[0]);
                    this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray3[0]);
                    this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray2[0]);
                }
                sharedResource = new SharedResource(eGLGraphicsDeviceArray[0], blArray2[0], gLRendererQuirksArray[0], nArray[0], blArray3[0], gLRendererQuirksArray2[0], nArray2[0], blArray4[0], gLRendererQuirksArray3[0], nArray3[0], blArray5[0], gLRendererQuirksArray4[0], nArray4[0]);
                if (bl2) {
                    defaultSharedResource = sharedResource;
                }
            }
            if (DEBUG_SHAREDCTX) {
                System.err.println("EGLDrawableFactory.MapGLVersions: mapSuccess " + bl + ", mappedToDefaultDevice " + blArray[0]);
                System.err.println("EGLDrawableFactory.MapGLVersions: defDevice  : " + defaultDevice);
                System.err.println("EGLDrawableFactory.MapGLVersions: adevice    : " + abstractGraphicsDevice);
                System.err.println("EGLDrawableFactory.MapGLVersions: eglDevice  : " + sharedResource.device);
                System.err.println("EGLDrawableFactory.MapGLVersions: context ES1: " + sharedResource.isAvailableES1 + ", quirks " + sharedResource.rendererQuirksES1);
                System.err.println("EGLDrawableFactory.MapGLVersions: context ES2: " + sharedResource.isAvailableES2 + ", quirks " + sharedResource.rendererQuirksES2);
                System.err.println("EGLDrawableFactory.MapGLVersions: context ES3: " + sharedResource.isAvailableES3 + ", quirks " + sharedResource.rendererQuirksES3);
                System.err.println("EGLDrawableFactory.MapGLVersions: context GLn: " + sharedResource.isAvailableGLn + ", quirks " + sharedResource.rendererQuirksGLn);
                EGLDrawableFactory.this.dumpMap();
            }
            return sharedResource;
        }

        private void handleDontCloseX11DisplayQuirk(GLRendererQuirks gLRendererQuirks) {
            if (null != gLRendererQuirks && gLRendererQuirks.exist(8)) {
                X11Util.markAllDisplaysUnclosable();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean mapAvailableEGLESConfig(AbstractGraphicsDevice abstractGraphicsDevice, boolean[] blArray, EGLGraphicsDevice[] eGLGraphicsDeviceArray) {
            Object object;
            Object object2;
            Object object3;
            EGLDrawable eGLDrawable;
            ProxySurface proxySurface;
            Object object4;
            boolean bl;
            String string = EGLContext.getGLProfile(2, 0, 8);
            if (!GLProfile.isAvailable(abstractGraphicsDevice, string)) {
                if (DEBUG_SHAREDCTX) {
                    System.err.println("EGLDrawableFactory.MapGLVersions: " + string + " n/a on " + abstractGraphicsDevice);
                }
                return false;
            }
            GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, string);
            GLDrawableFactoryImpl gLDrawableFactoryImpl = (GLDrawableFactoryImpl)GLDrawableFactory.getDesktopFactory();
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(5);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setAlphaBits(0);
            gLCapabilities.setDoubleBuffered(false);
            GLCapabilitiesImmutable gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilities);
            List list = EGLDrawableFactory.getAvailableEGLConfigs(defaultDevice, gLCapabilitiesImmutable);
            boolean bl2 = list.size() > 0;
            boolean bl3 = abstractGraphicsDevice == defaultDevice;
            boolean bl4 = blArray[0] = !bl3 && null != defaultSharedResource && defaultSharedResource.isAvailable && defaultConnection.equals(abstractGraphicsDevice.getConnection());
            if (DEBUG_SHAREDCTX) {
                System.err.println("EGLDrawableFactory.MapGLVersions: " + string + " ( " + 2 + " ), mapsADeviceToDefaultDevice " + blArray[0] + " (useDefaultDevice " + bl3 + ", defaultDeviceHasPBuffer " + bl2 + ", hasDesktopFactory " + (null != gLDrawableFactoryImpl) + ", isEGLGraphicsDevice " + (abstractGraphicsDevice instanceof EGLGraphicsDevice) + ")");
            }
            if (blArray[0]) {
                return true;
            }
            boolean bl5 = GLRendererQuirks.existStickyDeviceQuirk(defaultDevice, 22);
            boolean bl6 = false;
            if (defaultDeviceEGLFeatures.hasKHRSurfaceless && !bl5) {
                bl = true;
                object4 = bl3 ? defaultDevice : abstractGraphicsDevice;
                proxySurface = EGLDrawableFactory.this.createSurfacelessImpl((AbstractGraphicsDevice)object4, false, gLCapabilities, gLCapabilities, null, 64, 64);
                eGLGraphicsDeviceArray[0] = (EGLGraphicsDevice)((ProxySurfaceImpl)proxySurface).getGraphicsConfiguration().getScreen().getDevice();
                if (DEBUG_SHAREDCTX) {
                    System.err.println("EGLDrawableFactory-MapGLVersions.0: " + eGLGraphicsDeviceArray[0]);
                }
                eGLDrawable = null;
                object3 = null;
                boolean bl7 = false;
                try {
                    eGLDrawable = (EGLDrawable)EGLDrawableFactory.this.createOnscreenDrawableImpl(proxySurface);
                    eGLDrawable.setRealized(true);
                    object3 = (EGLContext)eGLDrawable.createContext(null);
                    if (null == object3) {
                        throw new GLException("Couldn't create shared context for drawable: " + eGLDrawable);
                    }
                    if (0 != ((GLContextImpl)object3).makeCurrent()) {
                        object2 = ((GLContextImpl)object3).getGL();
                        object = object2.glGetString(7938);
                        if (null != object) {
                            bl6 = true;
                        } else {
                            EGLDrawableFactory.this.setNoSurfacelessCtxQuirk((GLContext)object3);
                        }
                    } else if (DEBUG_SHAREDCTX) {
                        System.err.println("EGLDrawableFactory-MapGLVersions.0: NOT_CURRENT: " + eGLGraphicsDeviceArray[0] + ", " + object3);
                    }
                }
                catch (Throwable throwable) {
                    bl7 = true;
                    if (DEBUG_SHAREDCTX) {
                        System.err.println("EGLDrawableFactory-MapGLVersions.0: INFO: context create/makeCurrent failed");
                        throwable.printStackTrace();
                    }
                }
                finally {
                    block66: {
                        if (null != object3) {
                            try {
                                ((GLContextImpl)object3).destroy();
                            }
                            catch (GLException gLException) {
                                if (!DEBUG_SHAREDCTX) break block66;
                                System.err.println("EGLDrawableFactory-MapGLVersions.0: INFO: destroy caught exception:");
                                gLException.printStackTrace();
                            }
                        }
                    }
                    if (null != eGLDrawable) {
                        eGLDrawable.setRealized(false);
                    }
                    if (null != proxySurface) {
                        ((ProxySurfaceImpl)proxySurface).destroyNotify();
                    }
                    if ((bl6 || bl7) && defaultDevice != eGLGraphicsDeviceArray[0] && null != eGLGraphicsDeviceArray[0]) {
                        eGLGraphicsDeviceArray[0].close();
                    }
                }
                if (bl6) {
                    return true;
                }
            } else {
                bl = false;
            }
            object4 = null;
            proxySurface = null;
            eGLDrawable = null;
            object3 = null;
            GLContextImpl gLContextImpl = null;
            object2 = null;
            object = null;
            try {
                if (bl3 && bl2) {
                    eGLGraphicsDeviceArray[0] = defaultDevice;
                    object4 = defaultDeviceEGLFeatures;
                    if (DEBUG_SHAREDCTX) {
                        System.err.println("EGLDrawableFactory-MapGLVersions.1: " + eGLGraphicsDeviceArray[0]);
                        System.err.println("EGLDrawableFactory-MapGLVersions.1: " + object4);
                    }
                    if (null != (object = EGLDrawableFactory.this.createDummySurfaceImpl(eGLGraphicsDeviceArray[0], false, gLCapabilitiesImmutable, gLCapabilitiesImmutable, null, 64, 64))) {
                        object.createNotify();
                        proxySurface = object;
                    }
                } else if (abstractGraphicsDevice != defaultDevice && null != (object2 = gLDrawableFactoryImpl.createDummySurface(abstractGraphicsDevice, gLCapabilities, null, 64, 64))) {
                    object2.createNotify();
                    eGLGraphicsDeviceArray[0] = EGLDisplayUtil.eglCreateEGLGraphicsDevice((NativeSurface)object2);
                    eGLGraphicsDeviceArray[0].open();
                    object4 = new EGLFeatures(eGLGraphicsDeviceArray[0]);
                    if (DEBUG_SHAREDCTX) {
                        System.err.println("EGLDrawableFactory-MapGLVersions.2: " + eGLGraphicsDeviceArray[0]);
                        System.err.println("EGLDrawableFactory-MapGLVersions.2: " + object4);
                    }
                    proxySurface = object2;
                }
                if (null != proxySurface) {
                    eGLDrawable = (EGLDrawable)EGLDrawableFactory.this.createOnscreenDrawableImpl(proxySurface);
                    eGLDrawable.setRealized(true);
                    gLContextImpl = (EGLContext)eGLDrawable.createContext(null);
                    if (null == gLContextImpl) {
                        throw new GLException("Couldn't create shared context for drawable: " + eGLDrawable);
                    }
                    if (0 != gLContextImpl.makeCurrent()) {
                        GL gL = gLContextImpl.getGL();
                        String string2 = gL.glGetString(7938);
                        if (null != string2) {
                            bl6 = true;
                            if (!bl && ((EGLFeatures)object4).hasKHRSurfaceless && (gLContextImpl.isGLES() || gLContextImpl.getGLVersionNumber().compareTo(GLContext.Version3_0) >= 0)) {
                                if (EGLDrawableFactory.this.probeSurfacelessCtx(gLContextImpl, false)) {
                                    object3 = gLContextImpl.getGLDrawable();
                                }
                            } else {
                                EGLDrawableFactory.this.setNoSurfacelessCtxQuirk(gLContextImpl);
                            }
                        } else if (DEBUG_SHAREDCTX) {
                            System.err.println("EGLDrawableFactory-MapGLVersions.12: NULL VERSION: " + eGLGraphicsDeviceArray[0] + ", " + gLContextImpl.getGLVersion());
                        }
                    } else if (DEBUG_SHAREDCTX) {
                        System.err.println("EGLDrawableFactory-MapGLVersions.12: NOT_CURRENT: " + eGLGraphicsDeviceArray[0] + ", " + gLContextImpl);
                    }
                }
            }
            catch (Throwable throwable) {
                if (DEBUG_SHAREDCTX) {
                    System.err.println("EGLDrawableFactory-MapGLVersions.12: INFO: context create/makeCurrent failed");
                    throwable.printStackTrace();
                }
                bl6 = false;
            }
            finally {
                block68: {
                    if (null != gLContextImpl) {
                        try {
                            gLContextImpl.destroy();
                        }
                        catch (GLException gLException) {
                            if (!DEBUG_SHAREDCTX) break block68;
                            System.err.println("EGLDrawableFactory-MapGLVersions.12: INFO: destroy caught exception:");
                            gLException.printStackTrace();
                        }
                    }
                }
                if (null != object3) {
                    object3.setRealized(false);
                }
                if (null != eGLDrawable) {
                    eGLDrawable.setRealized(false);
                }
                if (null != object) {
                    object.destroyNotify();
                }
                if (defaultDevice != eGLGraphicsDeviceArray[0] && null != eGLGraphicsDeviceArray[0]) {
                    eGLGraphicsDeviceArray[0].close();
                }
                if (null != object2) {
                    object2.destroyNotify();
                }
            }
            return bl6;
        }

        @Override
        public void releaseSharedResource(SharedResourceRunner.Resource resource) {
            SharedResource sharedResource = (SharedResource)resource;
            if (DEBUG_SHAREDCTX) {
                System.err.println("Shutdown Shared:");
                System.err.println("Device  : " + sharedResource.device);
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
            if (null != sharedResource.device) {
                sharedResource.device.close();
                sharedResource.device = null;
            }
        }
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private EGLGraphicsDevice device;
        final boolean isAvailable;
        final boolean isAvailableES1;
        final boolean isAvailableES2;
        final boolean isAvailableES3;
        final boolean isAvailableGLn;
        final GLRendererQuirks rendererQuirksES1;
        final GLRendererQuirks rendererQuirksES2;
        final GLRendererQuirks rendererQuirksES3;
        final GLRendererQuirks rendererQuirksGLn;
        final int ctpES1;
        final int ctpES2;
        final int ctpES3;
        final int ctpGLn;

        SharedResource(EGLGraphicsDevice eGLGraphicsDevice, boolean bl, GLRendererQuirks gLRendererQuirks, int n, boolean bl2, GLRendererQuirks gLRendererQuirks2, int n2, boolean bl3, GLRendererQuirks gLRendererQuirks3, int n3, boolean bl4, GLRendererQuirks gLRendererQuirks4, int n4) {
            this.device = eGLGraphicsDevice;
            this.isAvailable = bl || bl2 || bl3 || bl4;
            this.isAvailableES1 = bl;
            this.rendererQuirksES1 = gLRendererQuirks;
            this.ctpES1 = n;
            this.isAvailableES2 = bl2;
            this.rendererQuirksES2 = gLRendererQuirks2;
            this.ctpES2 = n2;
            this.isAvailableES3 = bl3;
            this.rendererQuirksES3 = gLRendererQuirks3;
            this.ctpES3 = n3;
            this.isAvailableGLn = bl4;
            this.rendererQuirksGLn = gLRendererQuirks4;
            this.ctpGLn = n4;
        }

        @Override
        public final boolean isAvailable() {
            return this.isAvailable;
        }

        @Override
        public final EGLGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public AbstractGraphicsScreen getScreen() {
            return null;
        }

        @Override
        public GLDrawableImpl getDrawable() {
            return null;
        }

        @Override
        public GLContextImpl getContext() {
            return null;
        }

        @Override
        public GLRendererQuirks getRendererQuirks(GLProfile gLProfile) {
            if (null == gLProfile) {
                if (null != this.rendererQuirksES3) {
                    return this.rendererQuirksES3;
                }
                if (null != this.rendererQuirksES2) {
                    return this.rendererQuirksES2;
                }
                if (null != this.rendererQuirksES1) {
                    return this.rendererQuirksES1;
                }
                return this.rendererQuirksGLn;
            }
            if (!gLProfile.isGLES()) {
                return this.rendererQuirksGLn;
            }
            if (gLProfile.isGLES1()) {
                return this.rendererQuirksES1;
            }
            if (gLProfile.isGLES2()) {
                return this.rendererQuirksES2;
            }
            return this.rendererQuirksES3;
        }
    }

    static class EGLAcc
    extends EGL {
        EGLAcc() {
        }

        protected static boolean resetProcAddressTable(DynamicLookupHelper dynamicLookupHelper) {
            return EGL.resetProcAddressTable(dynamicLookupHelper);
        }
    }

    private static class EGLFeatures {
        public final String vendor;
        public final VersionNumber version;
        public final boolean hasGLAPI;
        public final boolean hasKHRCreateContext;
        public final boolean hasKHRSurfaceless;

        public EGLFeatures(EGLGraphicsDevice eGLGraphicsDevice) {
            long l = eGLGraphicsDevice.getHandle();
            this.vendor = EGL.eglQueryString(l, 12371);
            if (DEBUG_SHAREDCTX) {
                System.err.println("EGLFeatures on device " + eGLGraphicsDevice + ", vendor " + this.vendor);
            }
            this.version = eGLGraphicsDevice.getEGLVersion();
            boolean bl = this.version.compareTo(GLContext.Version1_4) >= 0;
            boolean bl2 = this.version.compareTo(GLContext.Version1_5) >= 0;
            boolean bl3 = false;
            String string = EGL.eglQueryString(l, 12429);
            if (bl) {
                String[] stringArray = string.split("\\s");
                for (int i = stringArray.length - 1; !bl3 && i >= 0; --i) {
                    bl3 = stringArray[i].equals("OpenGL");
                }
            }
            this.hasGLAPI = bl3;
            if (DEBUG_SHAREDCTX) {
                System.err.println("  Client APIs: '" + string + "'; has EGL 1.4 " + bl + " -> has OpenGL " + this.hasGLAPI);
            }
            String string2 = EGLContext.getPlatformExtensionsStringImpl(eGLGraphicsDevice).toString();
            if (bl2) {
                this.hasKHRCreateContext = true;
                this.hasKHRSurfaceless = true;
            } else {
                this.hasKHRCreateContext = bl ? string2.contains("EGL_KHR_create_context") : false;
                this.hasKHRSurfaceless = string2.contains("EGL_KHR_surfaceless_context");
            }
            if (DEBUG_SHAREDCTX) {
                System.err.println("  Extensions: " + string2);
                System.err.println("  KHR_create_context: " + this.hasKHRCreateContext);
                System.err.println("  KHR_surfaceless_context: " + this.hasKHRSurfaceless);
            }
        }

        public final String toString() {
            return "EGLFeatures[vendor " + this.vendor + ", version " + this.version + ", has[GL-API " + this.hasGLAPI + ", KHR[CreateContext " + this.hasKHRCreateContext + ", Surfaceless " + this.hasKHRSurfaceless + "]]]";
        }
    }
}

