#include <stdio.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include "init.h"
#include "draw.h"
#include "update.h"
#include "globals.h"
#include "loader.h"

void MainLoop()
{
    //nebulaMouseCoords.x = 0.0f;
    //nebulaMouseCoords.y = 0.0f;


	int frameCount = 0;
    int secondUnderWay = 0;
	int lastTime = SDL_GetTicks();

	//printf("FOV: %f\n", gCamera.fov);

	while (gameRunning)
	{

		int thisTime = SDL_GetTicks();
		masterTimer = thisTime;
		frameCount++;
		if (thisTime/1000 > secondUnderWay)
        {
            if (1)//(showFPS)
            {
                printf("FPS: %d\n", frameCount);
            }
            currentFPS = frameCount;
            secondUnderWay++;
            frameCount = 0;
        }
        int timeElapsed = thisTime - lastTime;
        if(!demoPaused) { demoTimer += timeElapsed; }
        if(demoPaused == false && Mix_PlayingMusic() == false) { Mix_PlayMusic(hanhiMusic12, 1); }
		Update((float)(timeElapsed));
		Draw();

		lastTime = thisTime;		
	}
}

int main(int argc, char* argv[])
{
	InitSystems();
	LoadSomeData();
	MainLoop();
	printf("haha\n");
	ShutDownSystems();

	return 0;
}