#include "init.h"
#include <GL/glew.h>
#include <SDL_mixer.h>
#include "imgui.h"
#include "imgui_impl_sdl_gl3.h"
#include "globals.h"
#include "camera.h"

int InitSystems()
{
	if (SDL_Init(SDL_INIT_VIDEO)){
		printf("SDL_Init failed.\n");
	}

	window = SDL_CreateWindow(
        "graahfathon 2017",
        SDL_WINDOWPOS_UNDEFINED,
        SDL_WINDOWPOS_UNDEFINED, 
        WINDOW_SIZE_X,
        WINDOW_SIZE_Y,
        CREATE_WINDOW_FLAGS
        );
    
    SDL_SetHint(SDL_HINT_VIDEO_HIGHDPI_DISABLED, "0");
    SDL_Init(SDL_INIT_VIDEO|SDL_INIT_TIMER|SDL_INIT_EVENTS);
    SDL_GL_SetAttribute(SDL_GL_CONTEXT_FLAGS, SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG);
    SDL_GL_SetAttribute(SDL_GL_CONTEXT_PROFILE_MASK, SDL_GL_CONTEXT_PROFILE_CORE);
    SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 3);
    SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 3);
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
    //SDL_GL_SetAttribute(SDL_GL_CONTEXT_FLAGS, SDL_GL_CONTEXT_DEBUG_FLAG); // 4.3+ only

    glContext = SDL_GL_CreateContext(window);


    // attempt to disable Vsync if requested
    if (disableVSyncAtStartup)
    {
        int trySetSwapInterval = SDL_GL_SetSwapInterval(0);
        printf("%d\n", trySetSwapInterval);
        if (trySetSwapInterval == -1)
        { 
            printf("%s\n", SDL_GetError());
        }
    }


    glewExperimental = GL_TRUE;    
    if(glewInit() != GLEW_OK) {
    	printf("glew not ok.\n");
    }



    // print out some info about the graphics drivers
    printf("OpenGL version: %s\n", glGetString(GL_VERSION));
    printf("GLSL version: %s\n", glGetString(GL_SHADING_LANGUAGE_VERSION));
    printf("Vendor: %s\n", glGetString(GL_VENDOR));
    printf("Renderer: %s\n", glGetString(GL_RENDERER));

    // OpenGL settings
    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	// SDL_mixer
	// load support for the OGG sample/music format
	int mix_flags = MIX_INIT_OGG;
	int mix_initted = Mix_Init(mix_flags);
	if (mix_initted&mix_flags != mix_flags) {
		printf("Mix_Init: Failed to init required ogg and mod support!\n");
		printf("Mix_Init: %s\n", Mix_GetError());
		// handle error
	}
	Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 2048);

	SDL_SetRelativeMouseMode(SDL_TRUE); 



    // Setup ImGui binding
    ImGui_ImplSdlGL3_Init(window);

    camera = SetCamera();

    SetCameraPosition(&camera, vec3(0,0,-4.535));   

    gLight.position = vec3(-127.0f, -13.0f, -2.0f);
    gLight.intensities = vec3(1.0f,1.0f,1.0f);

    SetCameraViewportAspectRatio(&camera, (float)WINDOW_SIZE_X / (float)WINDOW_SIZE_Y);

    cameraKeyFrames.push_back( NewCameraKeyFrame( vec3(-125.0f, -2.3f, -2.8f), 280.0f,5.0f, 9500 ) );
    cameraKeyFrames.push_back( NewCameraKeyFrame( vec3(1.9f, -1.2f, -3.8f),295.0f, 5.0f, 30000 ) );
    cameraKeyFrames.push_back( NewCameraKeyFrame( vec3(10.0f, -11.0f, 4.4f), 180.0f, 17.f, 39000));
    cameraKeyFrames.push_back( NewCameraKeyFrame( vec3(10.0f, -11.0f, 4.4f), 100.0f, 17.f, 69000));
}


int ShutDownSystems()
{
	ImGui_ImplSdlGL3_Shutdown();
	SDL_GL_DeleteContext(glContext);
    SDL_DestroyWindow(window);
    SDL_Quit();
    return 0;
}
