import moonlander.library.*;
import ddf.minim.*;

Moonlander moon;

// init art
PShape obu1;
PShape eppu;

PGraphics skrolli;
PGraphics greets;
PImage overlay;
PImage eppuNormal;

PGraphics effu1;
PGraphics effu2;
PGraphics effu3;

PFont fontti;

// init greetings
StringList greetings;


void setup() {
  frameRate(60);
  size(1920,1080,P3D);
  background(0);
  lights();
  noSmooth();
  
  fontti = loadFont("Emulogic-48.vlw");
  // load models
  obu1 = loadShape("portti.obj");
  eppu = loadShape("hireseppu.obj");
  
  // setup buffers
  skrolli = createGraphics(128, 128, P2D);
  greets = createGraphics(128, 128, P2D);
  
  effu1 = createGraphics(width, height, P3D);
  effu2 = createGraphics(width, height, P3D);
  effu3 = createGraphics(width, height, P3D);

  // load couple bitmaps  
  overlay = loadImage("overlay1.png");
  eppuNormal = loadImage("eppuNormal.png");
  
  // setting up greetings
  greetings = new StringList();
  greetings.append("DEKADENCE");
  greetings.append("JUMALAUTA");
  greetings.append("TRI LOBIT");
  greetings.append("EVEANGE L");
  greetings.append("PRIMITIVE");
  greetings.append("FAIRLIGHT");
  greetings.append("HKSAE CR ");
  greetings.append("BYTERAPRS");
  greetings.append("  ALUMNI ");
  greetings.append("BOOZMBIES");
  greetings.append("W A M M A");
  greetings.append(" PARAGUAY");
  greetings.append("DAMONES  ");
  greetings.append("E  POC  H");
  greetings.append("IVORYLABS");
  greetings.append(" JU  G  Z");
  greetings.append("EX TEN  D");
  greetings.append("COMPOCREW");
  greetings.append(" WIDELOAD");
  greetings.append("IVORYLABS");
  greetings.append("BOOZEMBLY");
  greetings.append("SUPERCELL");
  greetings.append("   ALL   ");
  greetings.append("    OF   ");
  greetings.append("   YOU   ");
   
  // load rocket w/ tune
  moon = Moonlander.initWithSoundtrack(this,"biisi.mp3",143,8);

  moon.start();

}

// this is ugly. why processing, why?
boolean sketchFullScreen() {
  return true;
}

void draw() {

  // fetch sync-data from ROCKET
  moon.update();
  double scene = moon.getValue("active_scene");
  double greetsControl = moon.getValue("greets_control");
  double backgroundColor = moon.getValue("background_color");
  double time = moon.getCurrentTime()*500;

  // scene switcher  
  switch((int)scene) {
   case 1:
    // wireframe array
    effect_1((float)time/420, (int)backgroundColor);
    image(effu1, 0, 0);
    break;
   case 2:
    // tunnel with model
    effect_2((float)time, (int)backgroundColor);
    image(effu2, 0, 0);
    break; 
   case 3:
    // greetings with head
    effect_3((float)time, (int)backgroundColor);
    image(effu3, 0, 0);
    greets((float)time, (float)greetsControl);
    blend(greets, 0, 0, greets.width, greets.height, 20, (int)(height*.45), 512, 512, ADD);
    break; 
  }
  
  // lets draw scroller on all scenes except greetings
  if((int)scene != 3) {
    // scroller on top
    scroller((float)time);
    blend(skrolli, 0, 0, skrolli.width, skrolli.height, (int)(width*.5-200), (int)(height*.5-200), 512, 512, DIFFERENCE);
  }
    
  // border noise on top, on all scenes
  blend(overlay, 0, 0, overlay.width, overlay.height, 0, 0, width, height, MULTIPLY);
 
}

void effect_1(float time, int bg) {
  // rotating and pulsing pile of spheres
  effu1.beginDraw();
  effu1.background(bg);
  effu1.noFill();
  effu1.pointLight(0,0,255.0,0,0,0);

  for(float i=1;i<(sin(time/5)*40+41);i+=2) {
    effu1.strokeWeight(sin(time+(i*42))*(6+i));
    effu1.stroke(sin(time/20*i)*420,128);
    effu1.pushMatrix();
      effu1.translate(width/2+sin(time)*200, height/2, 0);
      effu1.rotateZ(sin(time/10)*10+i);
      effu1.rotateX(sin(time/300)*10*i);
      effu1.sphereDetail((int)(sin(i*10)*4+5));
      effu1.sphere(100+(sin(time*i/10)*60+i*42));
    effu1.popMatrix();
  }
  effu1.endDraw();
}

void effect_2(float time, int bg) {
  // a tunnel made with model
  effu2.beginDraw();
  effu2.background(bg);
  effu2.pointLight(0,0,255.0,sin(time/400)*100,cos(time/500)*400,0);
  effu2.pointLight(255,255,255.0,cos(time/400)*100,sin(time/500)*400,0);

  for(float i=0; i<500; i+=15) {
    effu2.pushMatrix();
      effu2.translate(width/2+sin((time+i)/400)*50, height/2+cos((time+i)/400)*50,-3000+i*10+(time/20));
      effu2.scale(sin((time+i*10)/500)*20+40);
      effu2.rotateZ(sin((time+i*20)/3000)*10);
      effu2.shininess(420);
      effu2.shape(obu1, 0, 0);
    effu2.popMatrix();
  }
  effu2.endDraw();
}

void effect_3(float time, int bg) {
  // greetings my friend! i have a head for you!
  effu3.beginDraw();
  effu3.pointLight(55.0,66.6,255.0,sin(time/400)*100,cos(time/500)*400,500);
  effu3.pointLight(255.,255.,255.0,cos(time/400)*100,sin(time/500)*400,-100);
  effu3.background(bg);
  
  // for some reason this doesn't load properly
  // i still leave it here, if someone (or me) will fix this later
  textureMode(NORMAL);
  effu3.texture(eppuNormal);

  effu3.pushMatrix();
    effu3.translate(effu3.width*.5, effu3.height*.5, 500);
    effu3.rotateZ(PI);
    effu3.rotateX(sin(time/2420)*.8);
    effu3.rotateY(cos(time/820)*1.5);
    effu3.shininess(420);
    effu3.shape(eppu, 0, 0);
  effu3.popMatrix();
  effu3.endDraw();
}

void scroller(float time) {
  // name should tell it all
  
  String teksti = "                                                                       ";
  teksti += " NALLEPERHE  @  GRAFFATHON   2 0 1 7        ";
  teksti += " HELLOOO EVERYBODY IT IS YOUR FAVOURITE  S P I I K K I  ON DA KEYS      ";
  teksti += " THIS SMALL DEMO IS A  C O M P L E T E L Y  @ PARTY MADE PRODUCTION     ";
  teksti += " I AM VERY TIRED AFTER ABOUT  2 8   H O U R S  OF HARD CODING AND STUFF ";
  teksti += " DEMO IS CREATED WITH PROCESSING USING ROCKET (KUDOS KUSMA!) AS SYNC-TOOL    ";
  teksti += " ART WAS MADE WITH REAPER, BLENDER AND VITTUGIMP                             ";
  teksti += "                                                                             ";
  teksti += "                                             ";
  teksti += " THIS TEXT SHOULDNT BE SHOWN.                ";
  teksti += " NALLEPERHE  @  GRAFFATHON  2 0 1 7     ";
  teksti += " NALLEPERHE  @  GRAFFATHON           ";
  teksti += "             ";
  teksti += "             ";

  int i = (int)((time/100) % (teksti.length()-8));
  if(i<0) i=0;
  
  skrolli.beginDraw();
  skrolli.background(0,0);
  skrolli.textFont(fontti, 48);
  skrolli.textSize(32);
  skrolli.fill(255);
  if(i>=6) skrolli.text(teksti.charAt(i-6),60,30);
  if(i>=7) skrolli.text(teksti.charAt(i-7),30,30);
  if(i>=8) skrolli.text(teksti.charAt(i-8),0,30);

  if(i>=3) skrolli.text(teksti.charAt(i-3),60,60);
  if(i>=4) skrolli.text(teksti.charAt(i-4),30,60);
  if(i>=5) skrolli.text(teksti.charAt(i-5),0,60);

  skrolli.text(teksti.charAt(i),60,90);
  if(i>=1) skrolli.text(teksti.charAt(i-1),30,90);
  if(i>=2) skrolli.text(teksti.charAt(i-2),0,90);
  
  skrolli.endDraw();
}

void greets(float time, float control) {
  // lets render 3x3 text matrice with great groups
  int greetSelector = (int)control;
  float greetsAlpha = 255*((float)control - greetSelector);
  
  String teksti = greetings.get(greetSelector);
  
  greets.beginDraw();
  greets.background(0,0);
  greets.textFont(fontti, 48);
  greets.textSize(32);
  greets.fill(255, (int)greetsAlpha);
  
  greets.text(teksti.charAt(2),60,30);
  greets.text(teksti.charAt(1),30,30);
  greets.text(teksti.charAt(0),0,30);

  greets.text(teksti.charAt(5),60,60);
  greets.text(teksti.charAt(4),30,60);
  greets.text(teksti.charAt(3),0,60);

  greets.text(teksti.charAt(8),60,90);
  greets.text(teksti.charAt(7),30,90);
  greets.text(teksti.charAt(6),0,90);
  
  greets.endDraw();
}
