;FASM source
COLOR EQU 0127B00B3H

RESX EQU 640
RESY EQU 480
RADIUS EQU 32
HEIGHT EQU 36

ORG 256
 PUSH   AX
 PUSH   0A000H
 POP    ES

 MOV    BX,121H
video:
 MOV    AX,4F02H
 MOV    SI,AX
 INT    10H
 MOV    BL,12H
 CMP    AH,BH
 JE     video

 MOV    AH,9
 MOV    DX,text
 INT    21H

 SALC

 MOV    DI,15*RESX*4+4*8*20-4
 MOV    BP,3*RESY/2
.0:
 MOV    BX,RESX*4
.1:
 PUSH   BP
.2:
 SCASB
 JZ     .4
 MOV    WORD [SI],RESX*4
 SUB    [SI],BX                 ; CX
 MOV    [SI+2],BP               ; CY
 MOV    EAX,COLOR               ; GB0R


 IN     AL,40H                  ; random

.3:
 ROL    EAX,8
 SUB    AH,CL
 CWD
 XOR    AH,DL
;ADD    AH,AH
 TEST   AL,AL
 JNZ    .3
 MOV    [SI+4],EAX              ; 0BGR
 ADD    SI,8
.4:
 DEC    DI
 STOSB
 STOSB
 STOSB
 ADD    BP,HEIGHT
 SUB    DI,4*RESX+3
 JNC    .2
 INC    CX
 POP    BP
 ADD    DI,16*RESX*4-4
 SUB    BX,RESX*4/80
 JNZ    .1
 SUB    BP,RESY
 JNC    .0
 MOV    AX,4F05H

nextframe:
 CWD
 MOV    CX,RESY*3
 MOV    DI,SP
nextline:
 MOV    BP,RESX*4
nextpixel:
 SUB    DI,SP
 JNZ    nobank
 PUSH   AX
 INT    10H
 POP    AX
 INC    DX
nobank:
 PUSHA
 FILD   WORD [SI]               ; CX
 FISUB  WORD [BX-16]            ; DX
 FLD    ST0                     ; DX DX
 FMUL   ST0,ST0                 ; DX2 DX
 FILD   WORD [SI+2]             ; CY DX2 DX
 FISUBR WORD [BX-8]             ; DY DX2 DX
 FADD   ST2,ST0                 ; DY DX2 DX+DY
 FMUL   ST0,ST0                 ; DY2 DX2 DX+DY
 FADDP  ST1,ST0                 ; DY2+DX2 DX+DY
 FILD   WORD [Radius2]          ; R2 DY2+DX2 DX+DY
 FCOMI  ST0,ST1                 ; R2 DX2+DY2 DX+DY
 FSUBRP ST1,ST0                 ; R2-DX2-DY2 DX+DY
 JNA    pixelok
intersection:
 FSQRT                          ; DZ DX+DY
 FIST   WORD [SI+BP]            ; DZ DX+DY
 MOV    DX,[SI+BP]
 CMP    [ES:DI+3],DL            ; Z buffer test
 JA     pixelok
 FADD   ST1,ST0                 ; DZ N.S
 FADD   ST0,ST1                 ; N.H N.S
 FXCH   ST1                     ; N.S N.H
 FMUL   DWORD [MAXCOL-2]        ; Intensity N.H
 FISTP  WORD [SI+BP]            ; N.H
 FLD    DWORD [Shine-2]         ; Shine N.H
VideoPtr:
 MOV    AX,[SI+BP]              ; Intensity
 NOT    AH                      ; Shadow test
 AND    AL,AH                   ; Diffuse
 ADD    AL,37*2                 ; Diffuse+Ambient
 MUL    BYTE [BX+SI+5]          ; Color*(Diffuse+Ambient)
 FCOMI  ST0,ST1                 ; Shine N.H
 SALC                           ; Highlight test
 OR     AL,AH                   ; Color*(Diffuse+Ambient)+Specular
 STOSB
 INC    BX
 JPO    VideoPtr
 XCHG   AX,DX                   ; Z coord
 STOSB                          ; write Z buffer
pixelok:
 FUCOMPP                        ; -

 POPA
 ADD    BP,SP
 JNZ    nextpixel
 DEC    CX
 DEC    CX
 LOOP   nextline
 SUB    SI,8
 CMP    AX,SI
 JC     nextframe

 POP    AX
 INT    16H
RETN

text:   DB '  SEMINAR  256B$'
;text:   DB 'VISIT 256BSEMINAR AT FUNCTION$'

Shine:  DB 9CH,42H ; DD 78.08   ; 2.44*RADIUS
Radius2 DW RADIUS*RADIUS
MAXCOL: DB 0FAH,40H ; DD 7.8125 ; 2*125/RADIUS

