﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Spawner : MonoBehaviour {

    public GameObject spawned;
    public int amount = 10;
    public float deviation_max = 1.8f;

    public float inactive_time = 10.0f;
    private float ellapsed_time = 110.0f;

	// Use this for initialization
	void Start () {

       
		
	}
	
	// Update is called once per frame
	void Update () {
		
        if(ellapsed_time > inactive_time)
        {
            for (int i = 0; i < amount; i++)
            {
                GameObject go = Instantiate(spawned);

                go.transform.position = this.gameObject.transform.position;

                Vector3 x = new Vector3(this.gameObject.transform.position.x + Random.Range(-deviation_max, deviation_max), 0, 0);
                Vector3 y = new Vector3(this.gameObject.transform.position.y + Random.Range(-deviation_max, deviation_max), 0, 0);

                go.transform.position += x;
                go.transform.position += y;
            }
            ellapsed_time = 0.0f;
            if(inactive_time > 3.0f)
                inactive_time -= Time.deltaTime;
        }
        else
        {
            ellapsed_time += Time.deltaTime;
        }

	}
}
