BTF5_Bitplane_Width  = 40
BTF5_Bitplane_Height = 256
BTF5_NumPlanosImagen = 5

CSA_Speed = 16 			;Debe ser potencia de 2: 1,2,4,8,16.
CSA_Font_AnchuraLetras   = 4	;En bytes, 32 pixels
CSA_Font_AlturaLetras    = 66    ;En pixels

CSA_Font_NumPlanes 	 = 5
CSA_Font_AnchoBitmap = 28	;En bytes

CSA_PosicionScroll  = 67
CSA_MargenDerecho = 4	;bytes?
CSA_PosImpresion = 40		;46


BTF5_Init:
	lea.l	BTF5_Imagen,a1
	lea.l	BTF5_Copper_Bitplanes+2,a2
	move.l	a1,d1

	REPEAT 	d0,BTF5_NumPlanosImagen TIMES
		swap	d1
		move.w	d1,(a2)
		swap	d1
		move.w	d1,4(a2)
		addq.l	#8,a2
		add.l	#BTF5_Bitplane_Width+CSA_MargenDerecho,d1
	END_REPEAT

	lea.l	BTF5_CopperList,a1
	move.l	a1,Cop1Lch+CustomBase

	clr.w 	CopJmp1+CustomBase

	rts	;
;--------------------------------------------------------------
; Invocada en cada VBG
;--------------------------------------------------------------
BTF5_Run:

	bsr		CSA_ScrollText

	rts


CSA_ScrollText:
	bsr	CSA_ImprimeTexto
	gblWaitBlitter

	moveq	#CSA_Speed,d0		;pseudovelocidad
	moveq	#16,d1
	
	sub.b	d0,d1		;16 - velocidad
	lsl.l	#8,d1		;shift
	lsl.l	#4,d1
	add.l	#$09f0,d1
	move.w	d1,BltCon0+CustomBase
	move.w	#0,BltCon1+CustomBase
		
	move.l	#$ffffffff,Bltafwm+CustomBase
	
	lea		BTF5_Imagen,a0
	add.l	#(CSA_PosicionScroll*CSA_Font_NumPlanes*(BTF5_Bitplane_Width+CSA_MargenDerecho))+2,a0
	move.l	a0,BltApth+CustomBase
	
	lea		BTF5_Imagen,a0
	add.l	#(CSA_PosicionScroll*CSA_Font_NumPlanes*(BTF5_Bitplane_Width+CSA_MargenDerecho)),a0
	move.l	a0,BltDPth+CustomBase
	
	move.w	#0,BltAMod+CustomBase
	move.w	#0,BltDMod+CustomBase	

	move.w	#(CSA_Font_AlturaLetras*CSA_Font_NumPlanes)<<6+((BTF5_Bitplane_Width+CSA_MargenDerecho-2)/2),BltSize+CustomBase	;22

	rts




CSA_ImprimeTexto:
	Jif.w 	#0,'=',CSA_ScrollLetra,CSA_ImprimeLetra
	add.w	#CSA_Speed,CSA_ScrollLetra
	Jif     #CSA_Font_AnchuraLetras*8,'>',CSA_ScrollLetra,.sal,.w
	move.w	#0,CSA_ScrollLetra
.sal:	
	rts



CSA_ImprimeLetra:
	Lea		CSA_TextoScroll,a0
	add.w	#CSA_Speed,CSA_ScrollLetra
	clear 	d0
	move.w	CSA_ScrollPos,d0
	move.b	(a0,d0.w),d0

.FinTexto:
	and.l   #$000000ff,d0 		;Limpiamos los bits no necesarios

	Jif.b 	#$f,'<>',d0,.CaracterNormal
	move.l  #-1,ParteDemo
	rts

.CaracterNormal:
	jsr		CSA_CalculaOffsetFont
	gblWaitBlitter

	move.w	#$09f0,BltCon0+CustomBase
	move.w	#0,BltCon1+CustomBase
	
	;Origen ------------------> Font
	Lea		BTF5_Delorian,a0
	add.l	d1,a0
	move.l	a0,BltAPth+CustomBase
	move.w	#CSA_Font_AnchoBitmap-CSA_Font_AnchuraLetras,BltAMod+CustomBase
	move.l	#-1,BltAFwm+CustomBase
	
	;Destino -----------------> Pantalla
	lea		BTF5_Imagen,a0
 	add.l	#(CSA_PosicionScroll*(BTF5_Bitplane_Width+CSA_MargenDerecho)*CSA_Font_NumPlanes)+CSA_PosImpresion,a0
	move.l	a0,BltDPth+CustomBase
	move.w	#((BTF5_Bitplane_Width+CSA_MargenDerecho)-CSA_Font_AnchuraLetras),BltDMod+CustomBase

	;Blit!	
	move.w	#CSA_Font_AlturaLetras*CSA_Font_NumPlanes<<6+2,BltSize+CustomBase
	add.w	#1,CSA_ScrollPos
	rts


;----------------------------------------------------------------------
;Calcula la direccion que ocupa la letra que se va a imprimir.
;Usa los registros d0 y d1
;Parametros: d0.b el caracter a imprimir
;----------------------------------------------------------------------
CSA_CalculaOffsetFont:

	clear 	d1
	andi.l 	#$000000ff,d0	
	move.w	d0,d1
	mulu.w	#CSA_Font_AnchuraLetras,d1
	rts



CSA_TextoScroll:
	dc.b 0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,$f
	even

CSA_ScrollPos: 	
	dc.w	0	;Posicion dentro del texto.

CSA_ScrollLetra:
	dc.w	0

	even