/*
 * Decompiled with CFR 0.152.
 */
package com.scene;

import com.demo.Main;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Morphing;
import com.iceberg.graphics3d.Texture;
import com.iceberg.input.Loader3D;
import com.iceberg.input.LoaderObj;
import java.io.IOException;
import java.util.Hashtable;

public class Asset {
    private Hashtable table = new Hashtable();

    public void clear() {
        this.table.clear();
    }

    public void remove(String string) {
        if (this.table.containsKey(string) && !Main.precache) {
            Mesh[] meshArray;
            Object v = this.table.get(string);
            if (v instanceof Texture) {
                meshArray = (Texture)v;
                meshArray.destroy();
                meshArray = null;
            }
            if (v instanceof Mesh) {
                meshArray = (Mesh)v;
                meshArray.destroy();
                meshArray = null;
            }
            if (v instanceof Mesh[]) {
                meshArray = (Mesh[])v;
                for (int i = 0; i < meshArray.length; ++i) {
                    Mesh mesh = meshArray[i];
                    mesh.destroy();
                    mesh = null;
                }
            }
            this.table.remove(string);
            v = null;
        }
    }

    public Texture getTexture(String string) {
        Texture texture = (Texture)this.table.get(string);
        if (texture == null) {
            texture = Texture.createTexture(string);
            this.table.put(string, texture);
        }
        return texture;
    }

    public void prepareTexture(String string) {
        Texture texture = (Texture)this.table.get(string);
        if (texture == null) {
            texture = Texture.createTexture(string);
            this.table.put(string, texture);
        }
    }

    public Texture getTexture(String string, boolean bl) {
        Texture texture = (Texture)this.table.get(string);
        if (texture == null) {
            texture = Texture.createTexture(string);
            this.table.put(string, texture);
        }
        if (texture != null) {
            texture.setPerspectiveCorrection(bl);
        }
        return texture;
    }

    public Mesh getMesh(String string, int n, int n2, int n3, int n4) throws IOException {
        Mesh mesh = (Mesh)this.table.get(string);
        if (mesh == null) {
            mesh = LoaderObj.load(string, n, n2, n3, n4);
            this.table.put(string, mesh);
        }
        return mesh;
    }

    public Mesh[] getMeshes_iceberg(String string, int n, int n2, int n3) throws IOException {
        Mesh[] meshArray = (Mesh[])this.table.get(string);
        if (meshArray == null) {
            meshArray = Loader3D.loadMeshes(string, n, n2, n3);
            this.table.put(string, meshArray);
        }
        return meshArray;
    }

    public void removeMeshes(String string) throws IOException {
        Mesh[] meshArray = (Mesh[])this.table.get(string);
        if (meshArray != null) {
            for (int i = 0; i < meshArray.length; ++i) {
                meshArray[i] = null;
            }
            this.table.remove(string);
        }
    }

    public Mesh[] getMeshes(String string, int n, int n2, int n3, int n4) throws IOException {
        Mesh[] meshArray = (Mesh[])this.table.get(string);
        if (meshArray == null) {
            meshArray = LoaderObj.loadMeshes(string, n, n2, n3, n4);
            this.table.put(string, meshArray);
        }
        return meshArray;
    }

    public Morphing getMorphing(String string, int n, int n2, int n3) throws IOException {
        String string2 = "morphing " + string;
        Morphing morphing = (Morphing)this.table.get(string2);
        if (morphing == null) {
            Mesh[] meshArray = LoaderObj.loadMeshes(string, n, n2, n3, 0);
            morphing = Morphing.create(meshArray);
            this.table.put(string2, morphing);
        }
        return morphing;
    }
}

