/*
 * Decompiled with CFR 0.152.
 */
package com.objects;

import com.iceberg.collide.Ray;
import com.iceberg.home.Home;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Matrix;
import com.iceberg.math.Vector3D;
import com.scene.GameObject;
import com.scene.Scene;

public abstract class Character
extends GameObject {
    private static int PLAYER_HEIGHT = 450;
    private static int PLAYER_RADIUS = 200;
    private int dj = 0;
    private static Ray tmpRay = new Ray();
    private Vector3D speed = new Vector3D();
    private boolean onFloor = false;

    public void setPosition(int n, int n2, int n3) {
        this.transform.setPosition(n, n2, n3);
    }

    public void update(Scene scene) {
        Vector3D vector3D = tmpRay.getStart();
        vector3D.set(this.speed);
        int n = (int)((float)PLAYER_RADIUS * 0.8f);
        if (vector3D.lengthSquared() > n * n) {
            vector3D.setLength(n);
        }
        this.transform.m03 += vector3D.x;
        this.transform.m13 += vector3D.y;
        this.transform.m23 += vector3D.z;
        this.speed.y += scene.getGravitation();
        if (this.onFloor) {
            this.dj = 0;
            this.speed.div(4);
        } else {
            this.speed.div(4);
            this.speed.y *= 4;
        }
    }

    protected void moveX(int n) {
        this.speed.x += this.transform.m00 * n >> 14;
        this.speed.z += this.transform.m20 * n >> 14;
    }

    protected void moveZ(int n) {
        this.speed.x += this.transform.m02 * n >> 14;
        this.speed.z += this.transform.m22 * n >> 14;
    }

    protected void rotX(int n) {
        Matrix matrix = new Matrix(this.transform);
        Matrix matrix2 = new Matrix();
        matrix2.setRotX(n);
        this.transform.mul(matrix2);
        if ((float)Math.abs(this.transform.m12) > 10922.667f) {
            this.transform.set(matrix);
        }
    }

    protected void rotY(int n) {
        this.transform.rotY(n);
    }

    protected void jump(int n, float f) {
        if (this.onFloor || this.dj < 2) {
            this.speed.y = n * (this.dj + 1);
            this.speed.x = (int)((float)this.speed.x * (f * (float)(this.dj + 1)));
            this.speed.z = (int)((float)this.speed.z * (f * (float)(this.dj + 1)));
            this.onFloor = false;
            ++this.dj;
        }
    }

    public void collisionTest(Home home) {
        tmpRay.reset();
        tmpRay.getStart().set(this.transform.m03, this.transform.m13 + PLAYER_HEIGHT, this.transform.m23);
        tmpRay.getDir().set(0, -PLAYER_HEIGHT, 0);
        home.rayCast(this.getPart(), tmpRay);
        this.onFloor = tmpRay.isCollision();
        if (tmpRay.isCollision()) {
            this.transform.m13 = Character.tmpRay.getCollisionPoint().y;
        }
        Vector3D vector3D = tmpRay.getStart();
        vector3D.set(this.transform.m03, this.transform.m13 + PLAYER_HEIGHT, this.transform.m23);
        boolean bl = home.sphereCast(this.getPart(), vector3D, PLAYER_RADIUS);
        if (bl) {
            this.transform.setPosition(vector3D.x, vector3D.y - PLAYER_HEIGHT, vector3D.z);
        }
    }

    public void collisionTest(GameObject gameObject) {
        if (gameObject instanceof Character) {
            Character.collisionTest(this, (Character)gameObject);
        }
    }

    private static void collisionTest(Character character, Character character2) {
        Matrix matrix = character.getTransform();
        Matrix matrix2 = character2.getTransform();
        int n = (PLAYER_RADIUS + PLAYER_RADIUS) / 2;
        int n2 = matrix.m03 - matrix2.m03;
        int n3 = matrix.m13 - matrix2.m13;
        int n4 = matrix.m23 - matrix2.m23;
        if (Math.abs(n2) > n || Math.abs(n3) > n || Math.abs(n4) > n) {
            return;
        }
        long l = (long)n2 * (long)n2 + (long)n3 * (long)n3 + (long)n4 * (long)n4;
        if (l < (long)(n * n)) {
            if (l != 0L) {
                l = (int)(1.0f / MathUtils.invSqrt(l));
            } else {
                n2 = 1;
            }
            int n5 = (int)((long)n - l);
            Vector3D vector3D = new Vector3D(n2, n3, n4);
            vector3D.setLength(n5 / 2);
            Character.move(matrix, vector3D.x, vector3D.y, vector3D.z);
            Character.move(matrix2, -vector3D.x, -vector3D.y, -vector3D.z);
        }
    }

    private static void move(Matrix matrix, int n, int n2, int n3) {
        matrix.m03 += n;
        matrix.m13 += n2;
        matrix.m23 += n3;
    }

    public boolean isOnFloor() {
        return this.onFloor;
    }

    public int getHeight() {
        return PLAYER_HEIGHT;
    }
}

