/*
 * Decompiled with CFR 0.152.
 */
package com.objects;

import com.iceberg.graphics3d.BoundingBox;
import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.MeshImage;
import com.iceberg.graphics3d.Morphing;
import com.iceberg.graphics3d.Texture;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Matrix;
import com.iceberg.math.Vector3D;
import com.objects.Character;
import com.scene.Asset;
import com.scene.GameObject;
import com.scene.Scene;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Bot
extends Character {
    private static Vector3D dir = new Vector3D();
    private static Vector3D up = new Vector3D();
    private static Vector3D side = new Vector3D();
    private static Vector3D tmpVec = new Vector3D();
    private static int MOVE_SPEED = 20;
    private int dis = 0;
    private MeshImage img;
    private BoundingBox boundingBox;
    private int frame;
    private GameObject enemy = null;
    private boolean visible = false;
    static /* synthetic */ Class class$com$objects$Player;

    public Bot(Asset asset, int n, int n2, int n3, String string, String string2) {
        try {
            this.setPosition(n, n2, n3);
            Texture texture = asset.getTexture(string2);
            Mesh mesh = asset.getMeshes(string, 40, 40, 40, texture.getWidth())[0];
            mesh.setTexture(texture);
            Morphing morphing = asset.getMorphing(string, 40, 40, 40);
            this.img = new MeshImage(mesh, morphing);
            this.img.setOffsetSZ(220);
            this.boundingBox = new BoundingBox(this.img.getAnimation());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void paintDebug(Graphics3D graphics3D, Graphics graphics, int n, int n2) {
        if (this.visible) {
            int n3 = this.boundingBox.getMinX();
            int n4 = this.boundingBox.getMinY();
            int n5 = this.boundingBox.getMaxX() - n3;
            int n6 = this.boundingBox.getMaxY() - n4;
            graphics.setColor(65280);
            graphics.drawRect(n3 + n, n4 + n2, n5, n6);
            graphics.drawString("Dir:" + this.transform.getRotZ(), n3 + n5 / 2, n4 - 20, 0);
            graphics.drawString("Dis:" + this.dis, n3 + n5 / 2, n4 - 60, 0);
            if (this.enemy != null) {
                graphics.drawString("DirP:" + MathUtils.getAnglez(this.enemy.getTransform().m03, this.enemy.getTransform().m23, this.transform.m03, this.transform.m23), n3 + n5 / 2, n4 - 40, 0);
            }
        }
    }

    protected void render(Graphics3D graphics3D, int n, int n2, int n3, int n4) {
        Matrix matrix = graphics3D.computeFinalMatrix(this.transform);
        if (this.boundingBox.isVisible(graphics3D, matrix, n, n2, n3, n4)) {
            this.img.setMatrix(matrix);
            graphics3D.addMeshImage(this.img, n, n2, n3, n4);
            this.visible = true;
        }
    }

    public void update(Scene scene) {
        super.update(scene);
        this.visible = false;
        this.frame = scene.getFrame();
        if (this.frame % 8 == 0 && this.enemy == null) {
            this.enemy = scene.find(class$com$objects$Player == null ? (class$com$objects$Player = Bot.class$("com.objects.Player")) : class$com$objects$Player);
        }
        if (this.enemy != null) {
            this.dis = this.getTransform().distanceSquared(this.enemy.getTransform());
            if (!this.ifEnVis(this.enemy)) {
                this.enemy = null;
            }
        }
        if (this.enemy != null) {
            this.lookAt(this.enemy.getTransform().m03, this.enemy.getTransform().m23);
            if (this.dis > MathUtils.squared(200)) {
                this.moveZ(MOVE_SPEED);
                this.img.getAnimation().addFrame(10240 / MOVE_SPEED);
            }
        }
    }

    protected boolean isNeedRecomputePart() {
        if (this.getPart() == -1) {
            return true;
        }
        return this.frame % 5 == 0 && super.isNeedRecomputePart();
    }

    protected void lookAt(int n, int n2) {
        dir.set(this.transform.m02, 0, this.transform.m22);
        tmpVec.set(n - this.transform.m03, 0, n2 - this.transform.m23);
        tmpVec.setLength(16384);
        dir.lerp(dir, tmpVec, 1024);
        Bot.setDir(this.transform, Bot.dir.x, Bot.dir.z);
    }

    private static void setDir(Matrix matrix, int n, int n2) {
        dir.set(n, 0, n2);
        dir.setLength(16384);
        if (Bot.equals(Bot.dir.x, Bot.dir.y, Bot.dir.z, matrix.m02, matrix.m12, matrix.m22)) {
            return;
        }
        up.set(0, 16384, 0);
        side.cross(up, dir, 14);
        side.setLength(16384);
        if (dir.lengthSquared() != 0 && side.lengthSquared() != 0) {
            matrix.setDir(Bot.dir.x, Bot.dir.y, Bot.dir.z);
            matrix.setSide(Bot.side.x, Bot.side.y, Bot.side.z);
            matrix.setUp(Bot.up.x, Bot.up.y, Bot.up.z);
        }
    }

    private static boolean equals(int n, int n2, int n3, int n4, int n5, int n6) {
        return Math.abs(n - n4) < 20 && Math.abs(n2 - n5) < 20 && Math.abs(n3 - n6) < 20;
    }

    private boolean ifEnVis(GameObject gameObject) {
        int n = Math.abs(MathUtils.getAnglez(gameObject.getTransform().m03, gameObject.getTransform().m23, this.transform.m03, this.transform.m23) - this.transform.getRotZ());
        n = Math.min(n, Math.abs(MathUtils.getAnglez(gameObject.getTransform().m03, gameObject.getTransform().m23, this.transform.m03, this.transform.m23) + 360 - this.transform.getRotZ()));
        n = Math.min(n, Math.abs(MathUtils.getAnglez(gameObject.getTransform().m03, gameObject.getTransform().m23, this.transform.m03, this.transform.m23) - 360 - this.transform.getRotZ()));
        return !(this.dis < MathUtils.squared(3500) && n < 92 || this.dis < MathUtils.squared(2500) && n < 100 || this.dis < MathUtils.squared(1500) && n < 120 || this.dis < MathUtils.squared(400) && n < 133 ? Math.abs(gameObject.getTransform().m13 - this.transform.m13) > 500 : this.dis > MathUtils.squared(200));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

