/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Morphing;
import com.iceberg.graphics3d.MultyTexture;
import com.iceberg.graphics3d.Polygon3V;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Texture;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.Matrix;
import java.util.Vector;

public class Mesh {
    private static final int[] sort = new int[]{1, 4, 10, 23, 57, 145, 356, 911, 1968, 4711, 11969, 27901, 84801};
    private String name;
    private MultyTexture texture;
    private Vertex[] vertices;
    public RenderObject[] polygons;

    public Mesh(Vertex[] vertexArray, RenderObject[] renderObjectArray) {
        this.vertices = vertexArray;
        this.polygons = renderObjectArray;
    }

    public void destroy() {
        this.name = null;
        this.texture = null;
        this.vertices = null;
        this.polygons = null;
    }

    public void setMode(byte by) {
        for (int i = 0; i < this.polygons.length; ++i) {
            RenderObject renderObject = this.polygons[i];
            if (renderObject instanceof Polygon4V) {
                ((Polygon4V)renderObject).mode = by;
            }
            if (!(renderObject instanceof Polygon3V)) continue;
            ((Polygon3V)renderObject).mode = by;
        }
    }

    public Mesh(Mesh[] meshArray) {
        if (meshArray.length == 1) {
            this.vertices = meshArray[0].getVertices();
            this.polygons = meshArray[0].getPolygons();
            return;
        }
        Vector<Vertex> vector = new Vector<Vertex>();
        Vector<RenderObject> vector2 = new Vector<RenderObject>();
        for (int i = 0; i < meshArray.length; ++i) {
            int n;
            Mesh mesh = meshArray[i];
            Vertex[] vertexArray = mesh.getVertices();
            RenderObject[] renderObjectArray = mesh.getPolygons();
            for (n = 0; n < vertexArray.length; ++n) {
                vector.addElement(vertexArray[n]);
            }
            for (n = 0; n < renderObjectArray.length; ++n) {
                vector2.addElement(renderObjectArray[n]);
            }
        }
        this.vertices = new Vertex[vector.size()];
        vector.copyInto(this.vertices);
        this.polygons = new RenderObject[vector2.size()];
        vector2.copyInto(this.polygons);
    }

    public void optimize() {
        int n = this.vertices.length;
        Vector<Vertex> vector = new Vector<Vertex>();
        for (int i = 0; i < this.vertices.length; ++i) {
            Vertex vertex = this.vertices[i];
            int n2 = Mesh.search(vector, vertex);
            if (n2 == -1) {
                vector.addElement(vertex);
                continue;
            }
            Mesh.replace(this.polygons, vertex, (Vertex)vector.elementAt(n2));
        }
        this.vertices = new Vertex[vector.size()];
        vector.copyInto(this.vertices);
    }

    private static int search(Vector vector, Vertex vertex) {
        for (int i = 0; i < vector.size(); ++i) {
            Vertex vertex2 = (Vertex)vector.elementAt(i);
            if (vertex2 == vertex || Math.abs(vertex2.x - vertex.x) >= 10 || Math.abs(vertex2.y - vertex.y) >= 10 || Math.abs(vertex2.z - vertex.z) >= 10) continue;
            return i;
        }
        return -1;
    }

    private static void replace(RenderObject[] renderObjectArray, Vertex vertex, Vertex vertex2) {
        for (int i = 0; i < renderObjectArray.length; ++i) {
            RenderObject renderObject;
            if (renderObjectArray[i] instanceof Polygon3V) {
                renderObject = (Polygon3V)renderObjectArray[i];
                if (renderObject.a == vertex) {
                    renderObject.a = vertex2;
                }
                if (renderObject.b == vertex) {
                    renderObject.b = vertex2;
                }
                if (renderObject.c == vertex) {
                    renderObject.c = vertex2;
                }
            }
            if (!(renderObjectArray[i] instanceof Polygon4V)) continue;
            renderObject = (Polygon4V)renderObjectArray[i];
            if (((Polygon4V)renderObject).a == vertex) {
                ((Polygon4V)renderObject).a = vertex2;
            }
            if (((Polygon4V)renderObject).b == vertex) {
                ((Polygon4V)renderObject).b = vertex2;
            }
            if (((Polygon4V)renderObject).c == vertex) {
                ((Polygon4V)renderObject).c = vertex2;
            }
            if (((Polygon4V)renderObject).d != vertex) continue;
            ((Polygon4V)renderObject).d = vertex2;
        }
    }

    public void project(Graphics3D graphics3D, Matrix matrix) {
        graphics3D.transformAndProjectVertices(this.vertices, matrix);
    }

    public void animate(Morphing morphing) {
        morphing.interpolation(this.vertices);
    }

    void render(Graphics3D graphics3D) {
        this.render(graphics3D, 0, 0, graphics3D.width, graphics3D.height);
    }

    void render(Graphics3D graphics3D, int n, int n2, int n3, int n4) {
        int n5;
        RenderObject[] renderObjectArray = this.polygons;
        for (n5 = 0; n5 < renderObjectArray.length; ++n5) {
            Mesh.computeSZ(renderObjectArray[n5]);
        }
        Mesh.sortShell(renderObjectArray, renderObjectArray.length);
        for (n5 = renderObjectArray.length - 1; n5 >= 0; --n5) {
            RenderObject renderObject = renderObjectArray[n5];
            short s = 0;
            if (renderObject instanceof Polygon4V) {
                s = ((Polygon4V)renderObject).tex;
            }
            if (renderObject instanceof Polygon3V) {
                s = ((Polygon3V)renderObject).tex;
            }
            if (!renderObject.isVisible(n, n2, n3, n4)) continue;
            renderObject.render(graphics3D, this.texture.textures[s]);
        }
    }

    private static final void computeSZ(RenderObject renderObject) {
        RenderObject renderObject2;
        if (renderObject instanceof Polygon3V) {
            renderObject2 = (Polygon3V)renderObject;
            renderObject2.sz = renderObject2.a.rz + renderObject2.b.rz + renderObject2.c.rz;
        }
        if (renderObject instanceof Polygon4V) {
            renderObject2 = (Polygon4V)renderObject;
            ((Polygon4V)renderObject2).sz = (((Polygon4V)renderObject2).a.rz + ((Polygon4V)renderObject2).b.rz + ((Polygon4V)renderObject2).c.rz + ((Polygon4V)renderObject2).d.rz >> 2) * 3;
        }
    }

    public final void offsetSz(int n) {
        for (int i = 0; i < this.polygons.length; ++i) {
            RenderObject renderObject;
            RenderObject renderObject2 = this.polygons[i];
            if (renderObject2 instanceof Polygon3V) {
                renderObject = (Polygon3V)renderObject2;
                renderObject.sz += n;
            }
            if (!(renderObject2 instanceof Polygon4V)) continue;
            renderObject = (Polygon4V)renderObject2;
            ((Polygon4V)renderObject).sz += n;
        }
    }

    private static void sortShell(RenderObject[] renderObjectArray, int n) {
        int[] nArray = sort;
        int n2 = 0;
        while (nArray[n2] < n) {
            ++n2;
        }
        while (--n2 >= 0) {
            int n3;
            for (int i = n3 = nArray[n2]; i < n; ++i) {
                RenderObject renderObject = renderObjectArray[i];
                int n4 = renderObject.sz;
                for (int j = i; j > n3 && renderObjectArray[j - n3].sz < n4; j -= n3) {
                    renderObjectArray[j] = renderObjectArray[j - n3];
                }
                renderObjectArray[j] = renderObject;
            }
        }
    }

    public int minX() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            n = Math.min(n, this.vertices[i].x);
        }
        return n;
    }

    public int minY() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            n = Math.min(n, this.vertices[i].y);
        }
        return n;
    }

    public int minZ() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            n = Math.min(n, this.vertices[i].z);
        }
        return n;
    }

    public int maxX() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            n = Math.max(n, this.vertices[i].x);
        }
        return n;
    }

    public int maxY() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            n = Math.max(n, this.vertices[i].y);
        }
        return n;
    }

    public int maxZ() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            n = Math.max(n, this.vertices[i].z);
        }
        return n;
    }

    public Mesh copy() {
        Object[] objectArray = this.getVertices();
        RenderObject[] renderObjectArray = this.getPolygons();
        Vertex[] vertexArray = new Vertex[objectArray.length];
        for (int i = 0; i < vertexArray.length; ++i) {
            Vertex vertex = objectArray[i];
            vertexArray[i] = new Vertex(vertex.x, vertex.y, vertex.z);
        }
        RenderObject[] renderObjectArray2 = new RenderObject[renderObjectArray.length];
        for (int i = 0; i < renderObjectArray2.length; ++i) {
            int n;
            int n2;
            int n3;
            RenderObject renderObject;
            RenderObject renderObject2 = renderObjectArray[i];
            if (renderObject2 instanceof Polygon3V) {
                renderObject = (Polygon3V)renderObject2;
                n3 = Mesh.search(objectArray, (Object)renderObject.a);
                n2 = Mesh.search(objectArray, (Object)renderObject.b);
                n = Mesh.search(objectArray, (Object)renderObject.c);
                renderObjectArray2[i] = new Polygon3V(vertexArray[n3], renderObject.au, renderObject.av, vertexArray[n2], renderObject.bu, renderObject.bv, vertexArray[n], renderObject.cu, renderObject.cv);
            }
            if (!(renderObject2 instanceof Polygon4V)) continue;
            renderObject = (Polygon4V)renderObject2;
            n3 = Mesh.search(objectArray, (Object)((Polygon4V)renderObject).a);
            n2 = Mesh.search(objectArray, (Object)((Polygon4V)renderObject).b);
            n = Mesh.search(objectArray, (Object)((Polygon4V)renderObject).c);
            int n4 = Mesh.search(objectArray, (Object)((Polygon4V)renderObject).d);
            renderObjectArray2[i] = new Polygon4V(vertexArray[n3], ((Polygon4V)renderObject).au, ((Polygon4V)renderObject).av, vertexArray[n2], ((Polygon4V)renderObject).bu, ((Polygon4V)renderObject).bv, vertexArray[n], ((Polygon4V)renderObject).cu, ((Polygon4V)renderObject).cv, vertexArray[n4], ((Polygon4V)renderObject).du, ((Polygon4V)renderObject).dv);
        }
        Mesh mesh = new Mesh(vertexArray, renderObjectArray2);
        mesh.setTexture(this.texture);
        return mesh;
    }

    private static int search(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setTexture(MultyTexture multyTexture) {
        this.texture = multyTexture;
    }

    public void setTexture() {
        this.texture = null;
    }

    public void setTexture(Texture texture) {
        this.texture = new MultyTexture(texture);
    }

    public MultyTexture getTexture() {
        return this.texture;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public RenderObject[] getPolygons() {
        return this.polygons;
    }
}

