/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.collide;

import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Polygon3V;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Vector3D;

public class SphereCast {
    private static final Vector3D temp = new Vector3D();
    private static final Vector3D nor = new Vector3D();
    private static final Vector3D v1 = new Vector3D();
    private static final Vector3D v2 = new Vector3D();
    private static final Vector3D v3 = new Vector3D();
    private static final Vector3D v4 = new Vector3D();

    public static boolean isSphereAABBCollision(Vector3D vector3D, int n, int n2, int n3, int n4, int n5) {
        return vector3D.x + n >= n2 && vector3D.z + n >= n4 && vector3D.x - n <= n3 && vector3D.z - n <= n5;
    }

    public static boolean sphereCast(Mesh mesh, Vector3D vector3D, int n) {
        RenderObject[] renderObjectArray = mesh.getPolygons();
        boolean bl = false;
        for (int i = 0; i < renderObjectArray.length; ++i) {
            Vertex vertex;
            Vertex vertex2;
            Vertex vertex3;
            RenderObject renderObject;
            RenderObject renderObject2 = renderObjectArray[i];
            int n2 = Integer.MAX_VALUE;
            if (renderObject2 instanceof Polygon3V) {
                renderObject = (Polygon3V)renderObject2;
                vertex3 = renderObject.a;
                vertex2 = renderObject.b;
                vertex = renderObject.c;
                if (SphereCast.max(vertex3.x, vertex2.x, vertex.x) < vector3D.x - n || SphereCast.min(vertex3.x, vertex2.x, vertex.x) > vector3D.x + n || SphereCast.max(vertex3.z, vertex2.z, vertex.z) < vector3D.z - n || SphereCast.min(vertex3.z, vertex2.z, vertex.z) > vector3D.z + n || SphereCast.max(vertex3.y, vertex2.y, vertex.y) < vector3D.y - n || SphereCast.min(vertex3.y, vertex2.y, vertex.y) > vector3D.y + n) continue;
                v1.set(vertex3.x, vertex3.y, vertex3.z);
                v2.set(vertex2.x, vertex2.y, vertex2.z);
                v3.set(vertex.x, vertex.y, vertex.z);
                nor.set(renderObject.nx, renderObject.ny, renderObject.nz);
                n2 = SphereCast.distanceSphereToPolygon(v1, v2, v3, nor, vector3D, n);
            } else if (renderObject2 instanceof Polygon4V) {
                renderObject = (Polygon4V)renderObject2;
                vertex3 = ((Polygon4V)renderObject).a;
                vertex2 = ((Polygon4V)renderObject).b;
                vertex = ((Polygon4V)renderObject).c;
                Vertex vertex4 = ((Polygon4V)renderObject).d;
                if (SphereCast.max(vertex3.x, vertex2.x, vertex.x, vertex4.x) < vector3D.x - n || SphereCast.min(vertex3.x, vertex2.x, vertex.x, vertex4.x) > vector3D.x + n || SphereCast.max(vertex3.z, vertex2.z, vertex.z, vertex4.z) < vector3D.z - n || SphereCast.min(vertex3.z, vertex2.z, vertex.z, vertex4.z) > vector3D.z + n || SphereCast.max(vertex3.y, vertex2.y, vertex.y, vertex4.y) < vector3D.y - n || SphereCast.min(vertex3.y, vertex2.y, vertex.y, vertex4.y) > vector3D.y + n) continue;
                v1.set(vertex3.x, vertex3.y, vertex3.z);
                v2.set(vertex2.x, vertex2.y, vertex2.z);
                v3.set(vertex.x, vertex.y, vertex.z);
                v4.set(vertex4.x, vertex4.y, vertex4.z);
                nor.set(((Polygon4V)renderObject).nx, ((Polygon4V)renderObject).ny, ((Polygon4V)renderObject).nz);
                n2 = SphereCast.distanceSphereToPolygon(v1, v2, v3, v4, nor, vector3D, n);
            }
            if (n2 == Integer.MAX_VALUE || n2 <= 0) continue;
            vector3D.add(-SphereCast.nor.x * n2 >> 12, -SphereCast.nor.y * n2 >> 12, -SphereCast.nor.z * n2 >> 12);
            bl = true;
        }
        return bl;
    }

    private static int min(int n, int n2, int n3) {
        return SphereCast.min(SphereCast.min(n, n2), n3);
    }

    private static int max(int n, int n2, int n3) {
        return SphereCast.max(SphereCast.max(n, n2), n3);
    }

    private static int min(int n, int n2, int n3, int n4) {
        return SphereCast.min(SphereCast.min(n, n2), SphereCast.min(n3, n4));
    }

    private static int max(int n, int n2, int n3, int n4) {
        return SphereCast.max(SphereCast.max(n, n2), SphereCast.max(n3, n4));
    }

    private static int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    private static int max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    private static int distanceSphereToPolygon(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, int n) {
        temp.set(vector3D5.x - vector3D.x, vector3D5.y - vector3D.y, vector3D5.z - vector3D.z);
        int n2 = temp.dot(vector3D4) >> 12;
        if (n2 > n) {
            return Integer.MAX_VALUE;
        }
        temp.set(vector3D5.x - (vector3D4.x * n2 >> 12), vector3D5.y - (vector3D4.y * n2 >> 12), vector3D5.z - (vector3D4.z * n2 >> 12));
        if (MathUtils.isPointOnPolygon(temp, vector3D, vector3D2, vector3D3, vector3D4)) {
            int n3 = n2;
            if (n2 < 0) {
                n3 = -n2;
            }
            n3 = n - n3;
            return n3;
        }
        int n4 = MathUtils.distanceToLine(vector3D5, vector3D, vector3D2);
        int n5 = MathUtils.distanceToLine(vector3D5, vector3D2, vector3D3);
        int n6 = MathUtils.distanceToLine(vector3D5, vector3D3, vector3D);
        int n7 = n4;
        if (n5 < n7) {
            n7 = n5;
        }
        if (n6 < n7) {
            n7 = n6;
        }
        if (n7 <= n * n) {
            return n - (int)(1.0f / MathUtils.invSqrt(n7));
        }
        return Integer.MAX_VALUE;
    }

    private static int distanceSphereToPolygon(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, Vector3D vector3D6, int n) {
        temp.set(vector3D6.x - vector3D.x, vector3D6.y - vector3D.y, vector3D6.z - vector3D.z);
        int n2 = temp.dot(vector3D5) >> 12;
        if (n2 > n) {
            return Integer.MAX_VALUE;
        }
        temp.set(vector3D6.x - (vector3D5.x * n2 >> 12), vector3D6.y - (vector3D5.y * n2 >> 12), vector3D6.z - (vector3D5.z * n2 >> 12));
        if (MathUtils.isPointOnPolygon(temp, vector3D, vector3D2, vector3D3, vector3D4, vector3D5)) {
            int n3 = n2;
            if (n2 < 0) {
                n3 = -n2;
            }
            n3 = n - n3;
            return n3;
        }
        int n4 = MathUtils.distanceToLine(vector3D6, vector3D, vector3D2);
        int n5 = MathUtils.distanceToLine(vector3D6, vector3D2, vector3D3);
        int n6 = MathUtils.distanceToLine(vector3D6, vector3D3, vector3D4);
        int n7 = MathUtils.distanceToLine(vector3D6, vector3D4, vector3D);
        int n8 = n4;
        if (n5 < n8) {
            n8 = n5;
        }
        if (n6 < n8) {
            n8 = n6;
        }
        if (n7 < n8) {
            n8 = n7;
        }
        if (n8 <= n * n) {
            return n - (int)(1.0f / MathUtils.invSqrt(n8));
        }
        return Integer.MAX_VALUE;
    }
}

