/*
 * Decompiled with CFR 0.152.
 */
package com.gameutils.audio;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    public static final boolean SUPPORTS_MIXING = System.getProperty("supports.mixing").endsWith("true");
    private InputStream is;
    private Player player;

    public Sound(String string) throws Exception {
        String string2 = string.toLowerCase();
        String string3 = "";
        if (string2.endsWith(".wav")) {
            string3 = "audio/X-wav";
        }
        if (string2.endsWith(".midi") || string2.endsWith(".mid")) {
            string3 = "audio/midi";
        }
        if (string2.endsWith(".amr")) {
            string3 = "audio/amr";
        }
        this.is = this.getClass().getResourceAsStream(string);
        this.player = Manager.createPlayer((InputStream)this.is, (String)string3);
        this.player.realize();
        this.player.prefetch();
        this.player.setLoopCount(1);
    }

    public void setLoopCount(int n) {
        this.player.setLoopCount(n);
    }

    public void start() {
        try {
            this.player.setMediaTime(0L);
            if (this.player.getState() != 400) {
                this.player.start();
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.player.stop();
            this.player.deallocate();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void setVolume(int n) {
        VolumeControl volumeControl;
        if (n < 1) {
            n = 1;
        }
        if (n > 100) {
            n = 100;
        }
        if ((volumeControl = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            volumeControl.setLevel(n);
        }
    }

    public void destroy() {
        try {
            if (this.player == null) {
                return;
            }
            this.stop();
            this.is.close();
            this.player.close();
            this.is = null;
            this.player = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void playTone(int n, int n2, int n3) {
        try {
            Manager.playTone((int)n, (int)n2, (int)n3);
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }
}

