/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.math;

import com.iceberg.math.MathUtils;
import com.iceberg.math.Matrix;

public final class Vector3D {
    public int x;
    public int y;
    public int z;

    public Vector3D() {
    }

    public Vector3D(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public Vector3D(Vector3D vector3D) {
        this.set(vector3D);
    }

    public void set(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public void set(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public void add(Vector3D vector3D) {
        this.x += vector3D.x;
        this.y += vector3D.y;
        this.z += vector3D.z;
    }

    public void sub(Vector3D vector3D) {
        this.x -= vector3D.x;
        this.y -= vector3D.y;
        this.z -= vector3D.z;
    }

    public void add(int n, int n2, int n3) {
        this.x += n;
        this.y += n2;
        this.z += n3;
    }

    public void div(int n) {
        this.x /= n;
        this.y /= n;
        this.z /= n;
    }

    public void mul(int n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
    }

    public void invert() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public int length() {
        return (int)(1.0f / MathUtils.invSqrt(this.x * this.x + this.y * this.y + this.z * this.z));
    }

    public int lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public long distanceSquared(Vector3D vector3D) {
        int n = this.x - vector3D.x;
        int n2 = this.y - vector3D.y;
        int n3 = this.z - vector3D.z;
        return (long)n * (long)n + (long)n2 * (long)n2 + (long)n3 * (long)n3;
    }

    public void setLength(int n) {
        int n2 = this.x * this.x + this.y * this.y + this.z * this.z;
        if (n2 == n * n) {
            return;
        }
        float f = MathUtils.invSqrt(n2) * (float)n;
        this.x = (int)((float)this.x * f);
        this.y = (int)((float)this.y * f);
        this.z = (int)((float)this.z * f);
    }

    public float cos(Vector3D vector3D) {
        int n = this.x;
        int n2 = this.y;
        int n3 = this.z;
        int n4 = vector3D.x;
        int n5 = vector3D.y;
        int n6 = vector3D.z;
        float f = MathUtils.invSqrt(n * n + n2 * n2 + n3 * n3);
        float f2 = MathUtils.invSqrt(n4 * n4 + n5 * n5 + n6 * n6);
        return (float)(n * n4 + n2 * n5 + n3 * n6) * (f * f2);
    }

    public int dot(Vector3D vector3D) {
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    public void cross(Vector3D vector3D, Vector3D vector3D2, int n) {
        this.x = vector3D.y * vector3D2.z - vector3D2.y * vector3D.z >> n;
        this.y = vector3D.z * vector3D2.x - vector3D2.z * vector3D.x >> n;
        this.z = vector3D.x * vector3D2.y - vector3D2.x * vector3D.y >> n;
    }

    public void lerp(Vector3D vector3D, Vector3D vector3D2, int n) {
        if (n < 0) {
            this.set(vector3D);
            return;
        }
        if (n > 4096) {
            this.set(vector3D2);
            return;
        }
        this.x = vector3D.x + ((vector3D2.x - vector3D.x) * n >> 12);
        this.y = vector3D.y + ((vector3D2.y - vector3D.y) * n >> 12);
        this.z = vector3D.z + ((vector3D2.z - vector3D.z) * n >> 12);
    }

    public void mul(Matrix matrix) {
        this.mul(matrix, this);
    }

    public void mul(Matrix matrix, Vector3D vector3D) {
        int n = matrix.m00 >> 2;
        int n2 = matrix.m01 >> 2;
        int n3 = matrix.m02 >> 2;
        int n4 = matrix.m10 >> 2;
        int n5 = matrix.m11 >> 2;
        int n6 = matrix.m12 >> 2;
        int n7 = matrix.m20 >> 2;
        int n8 = matrix.m21 >> 2;
        int n9 = matrix.m22 >> 2;
        int n10 = (this.x * n >> 12) + (this.y * n2 >> 12) + (this.z * n3 >> 12) + matrix.m03;
        int n11 = (this.x * n4 >> 12) + (this.y * n5 >> 12) + (this.z * n6 >> 12) + matrix.m13;
        int n12 = (this.x * n7 >> 12) + (this.y * n8 >> 12) + (this.z * n9 >> 12) + matrix.m23;
        vector3D.x = n10;
        vector3D.y = n11;
        vector3D.z = n12;
    }

    public static void mul(Matrix matrix, Vector3D[] vector3DArray, Vector3D[] vector3DArray2) {
        int n = matrix.m00 >> 2;
        int n2 = matrix.m01 >> 2;
        int n3 = matrix.m02 >> 2;
        int n4 = matrix.m10 >> 2;
        int n5 = matrix.m11 >> 2;
        int n6 = matrix.m12 >> 2;
        int n7 = matrix.m20 >> 2;
        int n8 = matrix.m21 >> 2;
        int n9 = matrix.m22 >> 2;
        int n10 = vector3DArray.length;
        for (int i = 0; i < n10; ++i) {
            Vector3D vector3D = vector3DArray[i];
            Vector3D vector3D2 = vector3DArray2[i];
            int n11 = vector3D.x;
            int n12 = vector3D.y;
            int n13 = vector3D.z;
            vector3D2.x = (n11 * n >> 12) + (n12 * n2 >> 12) + (n13 * n3 >> 12) + matrix.m03;
            vector3D2.y = (n11 * n4 >> 12) + (n12 * n5 >> 12) + (n13 * n6 >> 12) + matrix.m13;
            vector3D2.z = (n11 * n7 >> 12) + (n12 * n8 >> 12) + (n13 * n9 >> 12) + matrix.m23;
        }
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }
}

