/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.math;

import com.iceberg.math.MathUtils;
import com.iceberg.math.Vector3D;

public class Matrix {
    public static final int fp = 14;
    public static final int FP = 16384;
    public int m00;
    public int m10;
    public int m20;
    public int m30;
    public int m01;
    public int m11;
    public int m21;
    public int m31;
    public int m02;
    public int m12;
    public int m22;
    public int m32;
    public int m03;
    public int m13;
    public int m23;
    public int m33;

    public Matrix() {
        this.setIdentity();
    }

    public Matrix(Matrix matrix) {
        this.set(matrix);
    }

    public void setIdentity() {
        this.m00 = 16384;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = 16384;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 16384;
        this.m23 = 0;
        this.m30 = 0;
        this.m31 = 0;
        this.m32 = 0;
        this.m33 = 16384;
    }

    public void set(Matrix matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m02 = matrix.m02;
        this.m03 = matrix.m03;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
        this.m12 = matrix.m12;
        this.m13 = matrix.m13;
        this.m20 = matrix.m20;
        this.m21 = matrix.m21;
        this.m22 = matrix.m22;
        this.m23 = matrix.m23;
        this.m30 = matrix.m30;
        this.m31 = matrix.m31;
        this.m32 = matrix.m32;
        this.m33 = matrix.m33;
    }

    public void set(int[] nArray) {
        this.m00 = nArray[0];
        this.m10 = nArray[1];
        this.m20 = nArray[2];
        this.m30 = nArray[3];
        this.m01 = nArray[4];
        this.m11 = nArray[5];
        this.m21 = nArray[6];
        this.m31 = nArray[7];
        this.m02 = nArray[8];
        this.m12 = nArray[9];
        this.m22 = nArray[10];
        this.m32 = nArray[11];
        this.m03 = nArray[12];
        this.m13 = nArray[13];
        this.m23 = nArray[14];
        this.m33 = nArray[15];
    }

    public void invert() {
        long l = ((long)this.m00 * (long)this.m03 >> 14) + ((long)this.m10 * (long)this.m13 >> 14) + ((long)this.m20 * (long)this.m23 >> 14);
        long l2 = ((long)this.m01 * (long)this.m03 >> 14) + ((long)this.m11 * (long)this.m13 >> 14) + ((long)this.m21 * (long)this.m23 >> 14);
        long l3 = ((long)this.m02 * (long)this.m03 >> 14) + ((long)this.m12 * (long)this.m13 >> 14) + ((long)this.m22 * (long)this.m23 >> 14);
        this.m03 = (int)(-l);
        this.m13 = (int)(-l2);
        this.m23 = (int)(-l3);
        int n = this.m01;
        this.m01 = this.m10;
        this.m10 = n;
        n = this.m02;
        this.m02 = this.m20;
        this.m20 = n;
        n = this.m12;
        this.m12 = this.m21;
        this.m21 = n;
    }

    public void setRotX(int n) {
        this.m00 = 16384;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = MathUtils.cos(n);
        this.m12 = -MathUtils.sin(n);
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = MathUtils.sin(n);
        this.m22 = MathUtils.cos(n);
        this.m23 = 0;
    }

    public void setRotY(int n) {
        this.m00 = MathUtils.cos(n);
        this.m01 = 0;
        this.m02 = MathUtils.sin(n);
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = 16384;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = -MathUtils.sin(n);
        this.m21 = 0;
        this.m22 = MathUtils.cos(n);
        this.m23 = 0;
    }

    public void setRotZ(int n) {
        this.m00 = MathUtils.cos(n);
        this.m01 = -MathUtils.sin(n);
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = MathUtils.sin(n);
        this.m11 = MathUtils.cos(n);
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 16384;
        this.m23 = 0;
    }

    public void mul(Matrix matrix) {
        this.mul(this, matrix);
    }

    public void mul(Matrix matrix, Matrix matrix2) {
        long l = (long)(matrix.m00 * matrix2.m00 + matrix.m01 * matrix2.m10 + matrix.m02 * matrix2.m20) + (long)matrix.m03 * (long)matrix2.m30 >> 14;
        long l2 = (long)(matrix.m00 * matrix2.m01 + matrix.m01 * matrix2.m11 + matrix.m02 * matrix2.m21) + (long)matrix.m03 * (long)matrix2.m31 >> 14;
        long l3 = (long)(matrix.m00 * matrix2.m02 + matrix.m01 * matrix2.m12 + matrix.m02 * matrix2.m22) + (long)matrix.m03 * (long)matrix2.m32 >> 14;
        long l4 = (long)matrix.m00 * (long)matrix2.m03 + (long)matrix.m01 * (long)matrix2.m13 + (long)matrix.m02 * (long)matrix2.m23 + (long)matrix.m03 * (long)matrix2.m33 >> 14;
        long l5 = (long)(matrix.m10 * matrix2.m00 + matrix.m11 * matrix2.m10 + matrix.m12 * matrix2.m20) + (long)matrix.m13 * (long)matrix2.m30 >> 14;
        long l6 = (long)(matrix.m10 * matrix2.m01 + matrix.m11 * matrix2.m11 + matrix.m12 * matrix2.m21) + (long)matrix.m13 * (long)matrix2.m31 >> 14;
        long l7 = (long)(matrix.m10 * matrix2.m02 + matrix.m11 * matrix2.m12 + matrix.m12 * matrix2.m22) + (long)matrix.m13 * (long)matrix2.m32 >> 14;
        long l8 = (long)matrix.m10 * (long)matrix2.m03 + (long)matrix.m11 * (long)matrix2.m13 + (long)matrix.m12 * (long)matrix2.m23 + (long)matrix.m13 * (long)matrix2.m33 >> 14;
        long l9 = (long)(matrix.m20 * matrix2.m00 + matrix.m21 * matrix2.m10 + matrix.m22 * matrix2.m20) + (long)matrix.m23 * (long)matrix2.m30 >> 14;
        long l10 = (long)(matrix.m20 * matrix2.m01 + matrix.m21 * matrix2.m11 + matrix.m22 * matrix2.m21) + (long)matrix.m23 * (long)matrix2.m31 >> 14;
        long l11 = (long)(matrix.m20 * matrix2.m02 + matrix.m21 * matrix2.m12 + matrix.m22 * matrix2.m22) + (long)matrix.m23 * (long)matrix2.m32 >> 14;
        long l12 = (long)matrix.m20 * (long)matrix2.m03 + (long)matrix.m21 * (long)matrix2.m13 + (long)matrix.m22 * (long)matrix2.m23 + (long)matrix.m23 * (long)matrix2.m33 >> 14;
        long l13 = (long)(matrix.m30 * matrix2.m00 + matrix.m31 * matrix2.m10 + matrix.m32 * matrix2.m20) + (long)matrix.m33 * (long)matrix2.m30 >> 14;
        long l14 = (long)(matrix.m30 * matrix2.m01 + matrix.m31 * matrix2.m11 + matrix.m32 * matrix2.m21) + (long)matrix.m33 * (long)matrix2.m31 >> 14;
        long l15 = (long)(matrix.m30 * matrix2.m02 + matrix.m31 * matrix2.m12 + matrix.m32 * matrix2.m22) + (long)matrix.m33 * (long)matrix2.m32 >> 14;
        long l16 = (long)matrix.m30 * (long)matrix2.m03 + (long)matrix.m31 * (long)matrix2.m13 + (long)matrix.m32 * (long)matrix2.m23 + (long)matrix.m33 * (long)matrix2.m33 >> 14;
        this.m00 = (int)l;
        this.m01 = (int)l2;
        this.m02 = (int)l3;
        this.m03 = (int)l4;
        this.m10 = (int)l5;
        this.m11 = (int)l6;
        this.m12 = (int)l7;
        this.m13 = (int)l8;
        this.m20 = (int)l9;
        this.m21 = (int)l10;
        this.m22 = (int)l11;
        this.m23 = (int)l12;
        this.m30 = (int)l13;
        this.m31 = (int)l14;
        this.m32 = (int)l15;
        this.m33 = (int)l16;
    }

    public void rotX(int n) {
        int n2 = MathUtils.cos(n);
        int n3 = MathUtils.sin(n);
        int n4 = this.m20 * n2 + this.m10 * n3 >> 14;
        int n5 = this.m21 * n2 + this.m11 * n3 >> 14;
        int n6 = this.m22 * n2 + this.m12 * n3 >> 14;
        int n7 = this.m10 * n2 - this.m20 * n3 >> 14;
        int n8 = this.m11 * n2 - this.m21 * n3 >> 14;
        int n9 = this.m12 * n2 - this.m22 * n3 >> 14;
        this.m20 = n4;
        this.m21 = n5;
        this.m22 = n6;
        this.m10 = n7;
        this.m11 = n8;
        this.m12 = n9;
    }

    public void rotY(int n) {
        int n2 = MathUtils.cos(n);
        int n3 = MathUtils.sin(n);
        int n4 = this.m00 * n2 + this.m20 * n3 >> 14;
        int n5 = this.m01 * n2 + this.m21 * n3 >> 14;
        int n6 = this.m02 * n2 + this.m22 * n3 >> 14;
        int n7 = this.m20 * n2 - this.m00 * n3 >> 14;
        int n8 = this.m21 * n2 - this.m01 * n3 >> 14;
        int n9 = this.m22 * n2 - this.m02 * n3 >> 14;
        this.m00 = n4;
        this.m01 = n5;
        this.m02 = n6;
        this.m20 = n7;
        this.m21 = n8;
        this.m22 = n9;
    }

    public void rotZ(int n) {
        int n2 = MathUtils.cos(n);
        int n3 = MathUtils.sin(n);
        int n4 = this.m10 * n2 + this.m00 * n3 >> 14;
        int n5 = this.m11 * n2 + this.m01 * n3 >> 14;
        int n6 = this.m12 * n2 + this.m02 * n3 >> 14;
        int n7 = this.m00 * n2 - this.m10 * n3 >> 14;
        int n8 = this.m01 * n2 - this.m11 * n3 >> 14;
        int n9 = this.m02 * n2 - this.m12 * n3 >> 14;
        this.m10 = n4;
        this.m11 = n5;
        this.m12 = n6;
        this.m00 = n7;
        this.m01 = n8;
        this.m02 = n9;
    }

    public void translate(int n, int n2, int n3) {
        if (n != 0) {
            this.m03 += this.m00 * n >> 14;
            this.m13 += this.m10 * n >> 14;
            this.m23 += this.m20 * n >> 14;
        }
        if (n2 != 0) {
            this.m03 += this.m01 * n2 >> 14;
            this.m13 += this.m11 * n2 >> 14;
            this.m23 += this.m21 * n2 >> 14;
        }
        if (n3 != 0) {
            this.m03 += this.m02 * n3 >> 14;
            this.m13 += this.m12 * n3 >> 14;
            this.m23 += this.m22 * n3 >> 14;
        }
    }

    public void scale(int n, int n2, int n3) {
        this.m00 = this.m00 * n >> 14;
        this.m10 = this.m10 * n >> 14;
        this.m20 = this.m20 * n >> 14;
        this.m01 = this.m01 * n2 >> 14;
        this.m11 = this.m11 * n2 >> 14;
        this.m21 = this.m21 * n2 >> 14;
        this.m02 = this.m02 * n3 >> 14;
        this.m12 = this.m12 * n3 >> 14;
        this.m22 = this.m22 * n3 >> 14;
    }

    public void setPosition(Vector3D vector3D) {
        this.setPosition(vector3D.x, vector3D.y, vector3D.z);
    }

    public void setSide(Vector3D vector3D) {
        this.setSide(vector3D.x, vector3D.y, vector3D.z);
    }

    public void setUp(Vector3D vector3D) {
        this.setUp(vector3D.x, vector3D.y, vector3D.z);
    }

    public void setDir(Vector3D vector3D) {
        this.setDir(vector3D.x, vector3D.y, vector3D.z);
    }

    public void getPosition(Vector3D vector3D) {
        vector3D.set(this.m03, this.m13, this.m23);
    }

    public void getSide(Vector3D vector3D) {
        vector3D.set(this.m00, this.m10, this.m20);
    }

    public void getUp(Vector3D vector3D) {
        vector3D.set(this.m01, this.m11, this.m21);
    }

    public void getDir(Vector3D vector3D) {
        vector3D.set(this.m02, this.m12, this.m22);
    }

    public void setPosition(int n, int n2, int n3) {
        this.m03 = n;
        this.m13 = n2;
        this.m23 = n3;
    }

    public void addPosition(int n, int n2, int n3) {
        this.m03 += n;
        this.m13 += n2;
        this.m23 += n3;
    }

    public void setSide(int n, int n2, int n3) {
        this.m00 = n;
        this.m10 = n2;
        this.m20 = n3;
    }

    public void setUp(int n, int n2, int n3) {
        this.m01 = n;
        this.m11 = n2;
        this.m21 = n3;
    }

    public void setDir(int n, int n2, int n3) {
        this.m02 = n;
        this.m12 = n2;
        this.m22 = n3;
    }

    public void rotX2(int n) {
        Matrix matrix = new Matrix();
        matrix.setRotX(n);
        this.mul(matrix);
    }

    public int distanceSquared(Matrix matrix) {
        int n = this.m03 - matrix.m03;
        int n2 = this.m13 - matrix.m13;
        int n3 = this.m23 - matrix.m23;
        long l = (long)n * (long)n + (long)(n2 * n2) + (long)(n3 * n3);
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public int getRotZ() {
        int n = MathUtils.getAnglez(0, 0, -this.m02, -this.m22);
        n = MathUtils.fixDegree(n);
        return n;
    }
}

