/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.home;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.home.Room;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Matrix;
import com.iceberg.math.Vector3D;
import javax.microedition.lcdui.Graphics;

public class Portal {
    private static final Vector3D tmpPos = new Vector3D();
    private static final Vector3D tmpPoint = new Vector3D();
    private static final Vector3D a = new Vector3D();
    private static final Vector3D b = new Vector3D();
    private static final Vector3D c = new Vector3D();
    private static final Vector3D d = new Vector3D();
    private Vertex[] poly;
    private Vector3D normal;
    private Room room1;
    private Room room2;
    public int minx;
    public int maxx;
    public int miny;
    public int maxy;

    public Portal(Vertex[] vertexArray) {
        this.poly = vertexArray;
        this.normal = Portal.createNormal(vertexArray[0], vertexArray[1], vertexArray[2]);
    }

    private static Vector3D createNormal(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        long l = (long)(vertex.y - vertex2.y) * (long)(vertex.z - vertex3.z) - (long)(vertex.z - vertex2.z) * (long)(vertex.y - vertex3.y);
        long l2 = (long)(vertex.z - vertex2.z) * (long)(vertex.x - vertex3.x) - (long)(vertex.x - vertex2.x) * (long)(vertex.z - vertex3.z);
        long l3 = (long)(vertex.x - vertex2.x) * (long)(vertex.y - vertex3.y) - (long)(vertex.y - vertex2.y) * (long)(vertex.x - vertex3.x);
        double d = Math.sqrt(l * l + l2 * l2 + l3 * l3) / 4096.0;
        int n = (int)((double)l / d);
        int n2 = (int)((double)l2 / d);
        int n3 = (int)((double)l3 / d);
        return new Vector3D(n, n2, n3);
    }

    public void drawDebug(Graphics3D graphics3D, Graphics graphics, int n, int n2) {
        graphics.setColor(0xFF0000);
        for (int i = 0; i < this.poly.length; ++i) {
            Vertex vertex = this.poly[i];
            Vertex vertex2 = this.poly[(i + 1) % this.poly.length];
            if (vertex.rz >= 0 && vertex2.rz >= 0) continue;
            graphics.drawLine(vertex.sx + n, vertex.sy + n2, vertex2.sx + n, vertex2.sy + n2);
        }
    }

    void setRoom1(Room room) {
        this.room1 = room;
    }

    void setRoom2(Room room) {
        this.room2 = room;
    }

    public Room getSecondRoom(Room room) {
        if (room == this.room1) {
            return this.room2;
        }
        if (room == this.room2) {
            return this.room1;
        }
        return null;
    }

    public Vertex[] getVertices() {
        return this.poly;
    }

    public int getMinX() {
        return this.minx;
    }

    public int getMinY() {
        return this.miny;
    }

    public int getMaxX() {
        return this.maxx;
    }

    public int getMaxY() {
        return this.maxy;
    }

    public boolean isVisible(Graphics3D graphics3D, int n, int n2, int n3, int n4) {
        int n5;
        Matrix matrix = graphics3D.getCamera();
        if (this.distanceToPortal(matrix.m03, matrix.m13, matrix.m23) < 300) {
            this.minx = n;
            this.miny = n2;
            this.maxx = n3;
            this.maxy = n4;
            return true;
        }
        matrix.getPosition(tmpPos);
        Vertex vertex = this.poly[0];
        Vertex vertex2 = this.poly[1];
        Vertex vertex3 = this.poly[2];
        Vertex vertex4 = this.poly[3];
        a.set(vertex.x, vertex.y, vertex.z);
        b.set(vertex2.x, vertex2.y, vertex2.z);
        c.set(vertex3.x, vertex3.y, vertex3.z);
        d.set(vertex4.x, vertex4.y, vertex4.z);
        if (Portal.isSpherePortalCollision(tmpPos, 300, a, b, c, d, this.normal)) {
            this.minx = n;
            this.miny = n2;
            this.maxx = n3;
            this.maxy = n4;
            return true;
        }
        graphics3D.transformAndProjectVertices(this.poly, graphics3D.getInvCamera());
        Vertex vertex5 = this.poly[0];
        this.minx = this.maxx = vertex5.sx;
        this.miny = this.maxy = vertex5.sy;
        int n6 = n5 = vertex5.rz;
        for (int i = 1; i < this.poly.length; ++i) {
            vertex5 = this.poly[i];
            this.minx = Math.min(this.minx, vertex5.sx);
            this.miny = Math.min(this.miny, vertex5.sy);
            this.maxx = Math.max(this.maxx, vertex5.sx);
            this.maxy = Math.max(this.maxy, vertex5.sy);
            n5 = Math.min(n5, vertex5.rz);
            n6 = Math.max(n6, vertex5.rz);
        }
        this.minx = Math.max(this.minx, n);
        this.miny = Math.max(this.miny, n2);
        this.maxx = Math.min(this.maxx, n3);
        this.maxy = Math.min(this.maxy, n4);
        return n5 < 0 && this.maxx > n && this.minx < n3 && this.maxy > n2 && this.miny < n4;
    }

    private static boolean isSpherePortalCollision(Vector3D vector3D, int n, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4, Vector3D vector3D5, Vector3D vector3D6) {
        tmpPoint.set(vector3D.x - vector3D2.x, vector3D.y - vector3D2.y, vector3D.z - vector3D2.z);
        int n2 = tmpPoint.dot(vector3D6) >> 12;
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 > n) {
            return false;
        }
        tmpPoint.set(vector3D.x - (vector3D6.x * n2 >> 12), vector3D.y - (vector3D6.y * n2 >> 12), vector3D.z - (vector3D6.z * n2 >> 12));
        return MathUtils.isPointOnPolygon(tmpPoint, vector3D2, vector3D3, vector3D4, vector3D5, vector3D6);
    }

    private int distanceToPortal(int n, int n2, int n3) {
        Vertex vertex = this.poly[0];
        int n4 = n - vertex.x;
        int n5 = n2 - vertex.y;
        int n6 = n3 - vertex.z;
        return Math.abs(n4 * this.normal.x + n5 * this.normal.y + n6 * this.normal.z >> 12);
    }
}

