/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.home;

import com.iceberg.collide.Ray;
import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Texture;
import com.iceberg.home.Portal;
import com.iceberg.home.Room;
import com.iceberg.home.RoomObject;
import com.iceberg.math.Vector3D;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Home {
    private Room[] rooms;
    private Room[][] neighbours;
    private Vector nearRooms = new Vector();
    private Vector renderedRooms = new Vector();
    private Vector renderedPortals = new Vector();
    private boolean openSky;

    public Home(Room[] roomArray, Room[][] roomArray2) {
        this.rooms = roomArray;
        this.neighbours = roomArray2;
    }

    public void setTexture(Texture texture) {
        for (int i = 0; i < this.rooms.length; ++i) {
            this.rooms[i].getMesh().setTexture(texture);
        }
    }

    public void setTexture(Texture texture, int n) {
        this.rooms[n].getMesh().setTexture(texture);
    }

    public void drawDebug(Graphics3D graphics3D, Graphics graphics, int n, int n2) {
        for (int i = 0; i < this.renderedPortals.size(); ++i) {
            Portal portal = (Portal)this.renderedPortals.elementAt(i);
            portal.drawDebug(graphics3D, graphics, n, n2);
        }
    }

    public int render(Graphics3D graphics3D, int n) {
        if (n == -1) {
            this.renderedRooms.removeAllElements();
            this.renderedPortals.removeAllElements();
            for (int i = 0; i < this.rooms.length; ++i) {
                this.rooms[i].setViewport(0, 0, graphics3D.getWidth(), graphics3D.getHeight());
                this.rooms[i].render(graphics3D);
            }
            return this.rooms.length;
        }
        this.openSky = false;
        this.renderedRooms.removeAllElements();
        this.renderedPortals.removeAllElements();
        this.render(graphics3D, this.rooms[n], 0, 0, graphics3D.getWidth(), graphics3D.getHeight());
        return this.renderedRooms.size();
    }

    private void render(Graphics3D graphics3D, Room room, int n, int n2, int n3, int n4) {
        if (room == null) {
            return;
        }
        this.openSky |= room.isOpenSky();
        room.setViewport(n, n2, n3, n4);
        room.render(graphics3D);
        this.renderedRooms.addElement(room);
        Portal[] portalArray = room.getPortals();
        for (int i = 0; i < portalArray.length; ++i) {
            Portal portal = portalArray[i];
            Room room2 = portal.getSecondRoom(room);
            if (this.renderedRooms.contains(room2) || !portal.isVisible(graphics3D, n, n2, n3, n4)) continue;
            int n5 = Math.max(portal.getMinX(), n);
            int n6 = Math.max(portal.getMinY(), n2);
            int n7 = Math.min(portal.getMaxX(), n3);
            int n8 = Math.min(portal.getMaxY(), n4);
            int n9 = n7 - n5;
            int n10 = n8 - n6;
            if (n9 < 10 && n10 < 10 || n9 < 3 || n10 < 3) continue;
            this.renderedPortals.addElement(portal);
            this.render(graphics3D, room2, n5, n6, n7, n8);
        }
    }

    public boolean sphereCast(int n, Vector3D vector3D, int n2) {
        Vector vector = this.getNearRooms(n);
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Room room = (Room)vector.elementAt(i);
            bl |= room.sphereCast(vector3D, n2);
        }
        return bl;
    }

    public void rayCast(int n, Ray ray) {
        Vector vector = this.getNearRooms(n);
        for (int i = 0; i < vector.size(); ++i) {
            Room room = (Room)vector.elementAt(i);
            room.rayCast(ray);
        }
    }

    public void longRayCast(int n, Ray ray) {
        Vector vector = this.getActiveRooms(n);
        for (int i = 0; i < vector.size(); ++i) {
            Room room = (Room)vector.elementAt(i);
            room.rayCast(ray);
        }
    }

    private Vector getNearRooms(int n) {
        this.nearRooms.removeAllElements();
        if (n == -1) {
            return this.nearRooms;
        }
        if (this.rooms[n] != null) {
            this.nearRooms.addElement(this.rooms[n]);
        }
        Room[] roomArray = this.neighbours[n];
        for (int i = 0; i < roomArray.length; ++i) {
            if (roomArray[i] == null) continue;
            this.nearRooms.addElement(roomArray[i]);
        }
        return this.nearRooms;
    }

    private Vector getActiveRooms(int n) {
        this.getNearRooms(n);
        int n2 = this.nearRooms.size();
        for (int i = 0; i < n2; ++i) {
            Room room = (Room)this.nearRooms.elementAt(i);
            Room[] roomArray = this.neighbours[room.getId()];
            for (int j = 0; j < roomArray.length; ++j) {
                Room room2 = roomArray[j];
                if (this.nearRooms.contains(room2)) continue;
                this.nearRooms.addElement(room2);
            }
        }
        return this.nearRooms;
    }

    public void getActiveObjects(Vector vector, int n) {
        vector.removeAllElements();
        if (n == -1) {
            return;
        }
        this.rooms[n].getObjects(vector);
        Room[] roomArray = this.neighbours[n];
        for (int i = 0; i < roomArray.length; ++i) {
            roomArray[i].getObjects(vector);
        }
    }

    public void addObject(RoomObject roomObject) {
        this.recomputePart(roomObject);
        if (roomObject.getPart() == -1) {
            System.out.println("Home: \u0420\u0455\u0420\u00b1\u0421\u0409\u0420\u00b5\u0420\u0454\u0421\u201a \u0420\u0405\u0420\u00b5 \u0420\u0458\u0420\u0455\u0420\u00b6\u0420\u00b5\u0421\u201a \u0420\u00b1\u0421\u2039\u0421\u201a\u0421\u040a \u0420\u0491\u0420\u0455\u0420\u00b1\u0420\u00b0\u0420\u0406\u0420\u00bb\u0420\u00b5\u0420\u0405");
            return;
        }
    }

    public void removeObject(RoomObject roomObject) {
        if (roomObject.getPart() != -1) {
            this.rooms[roomObject.getPart()].removeObject(roomObject);
        } else {
            System.out.println("Home: \u0420\u0455\u0420\u00b1\u0421\u0409\u0420\u00b5\u0420\u0454\u0421\u201a \u0420\u0405\u0420\u00b5 \u0420\u0458\u0420\u0455\u0420\u00b6\u0420\u00b5\u0421\u201a \u0420\u00b1\u0421\u2039\u0421\u201a\u0421\u040a \u0421\u0453\u0420\u0491\u0420\u00b0\u0420\u00bb\u0420\u00b5\u0420\u0405");
        }
    }

    public void recomputePart(RoomObject roomObject) {
        if (roomObject.isNeedRecomputePart()) {
            int n = roomObject.getPart();
            int n2 = this.computePart(n, roomObject.getPosX(), roomObject.getPosZ());
            roomObject.setPart(n2);
            if (n != n2) {
                if (n != -1 && n2 != -1) {
                    this.rooms[n].removeObject(roomObject);
                }
                if (n2 != -1) {
                    this.rooms[n2].addObject(roomObject);
                }
            }
        }
    }

    private int computePart(int n, int n2, int n3) {
        if (n != -1) {
            if (this.rooms[n].isPointOnMesh(n2, n3) != -1) {
                return n;
            }
            Room[] roomArray = this.neighbours[n];
            for (int i = 0; i < roomArray.length; ++i) {
                if (roomArray[i].isPointOnMesh(n2, n3) == -1) continue;
                return roomArray[i].getId();
            }
        }
        for (int i = 0; i < this.rooms.length; ++i) {
            if (this.rooms[i].isPointOnMesh(n2, n3) == -1) continue;
            return i;
        }
        return -1;
    }

    public boolean isNeighbours(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        Room[] roomArray = this.neighbours[n];
        for (int i = 0; i < roomArray.length; ++i) {
            if (roomArray[i].getId() != n2) continue;
            return true;
        }
        return false;
    }

    public boolean isOpenSky() {
        return this.openSky;
    }
}

