/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.MultyTexture;
import com.iceberg.graphics3d.Polygon3V;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.TMPElement;
import com.iceberg.graphics3d.Texture;

public class RenderObjectBuffer {
    private static final int[] sort = new int[]{1, 4, 10, 23, 57, 145, 356, 911, 1968, 4711, 11969, 27901, 84801};
    private TMPElement[] buffer = new TMPElement[0];
    private int size = 0;

    RenderObjectBuffer() {
    }

    void addRenderObjects(RenderObject[] renderObjectArray, Texture texture, int n, int n2, int n3, int n4) {
        int n5 = renderObjectArray.length;
        for (int i = 0; i < n5; ++i) {
            RenderObject renderObject = renderObjectArray[i];
            if (!renderObject.isVisible(n, n2, n3, n4)) continue;
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement tMPElement = this.buffer[this.size];
            tMPElement.obj = renderObject;
            tMPElement.tex = texture;
            ++this.size;
        }
    }

    void addRenderObjects(RenderObject[] renderObjectArray, MultyTexture multyTexture, int n, int n2, int n3, int n4) {
        int n5 = renderObjectArray.length;
        for (int i = 0; i < n5; ++i) {
            RenderObject renderObject = renderObjectArray[i];
            if (!renderObject.isVisible(n, n2, n3, n4)) continue;
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement tMPElement = this.buffer[this.size];
            tMPElement.obj = renderObject;
            tMPElement.tex = multyTexture.textures[0];
            if (renderObject instanceof Polygon4V) {
                tMPElement.tex = multyTexture.textures[((Polygon4V)renderObject).tex];
            }
            if (renderObject instanceof Polygon3V) {
                tMPElement.tex = multyTexture.textures[((Polygon3V)renderObject).tex];
            }
            ++this.size;
        }
    }

    void addRenderObject(TMPElement tMPElement, int n, int n2, int n3, int n4) {
        RenderObject renderObject = tMPElement.obj;
        if (renderObject.isVisible(n, n2, n3, n4)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement tMPElement2 = this.buffer[this.size];
            tMPElement2.obj = tMPElement.obj;
            tMPElement2.tex = tMPElement.tex;
            ++this.size;
        }
    }

    void addRenderObject(RenderObject renderObject, Texture texture, int n, int n2, int n3, int n4) {
        if (renderObject.isVisible(n, n2, n3, n4)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement tMPElement = this.buffer[this.size];
            tMPElement.obj = renderObject;
            tMPElement.tex = texture;
            ++this.size;
        }
    }

    void addRenderObject(RenderObject renderObject, MultyTexture multyTexture, int n, int n2, int n3, int n4) {
        if (renderObject.isVisible(n, n2, n3, n4)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement tMPElement = this.buffer[this.size];
            tMPElement.obj = renderObject;
            tMPElement.tex = multyTexture.textures[0];
            if (renderObject instanceof Polygon4V) {
                tMPElement.tex = multyTexture.textures[((Polygon4V)renderObject).tex];
            }
            if (renderObject instanceof Polygon3V) {
                tMPElement.tex = multyTexture.textures[((Polygon3V)renderObject).tex];
            }
            ++this.size;
        }
    }

    void addRenderObject(RenderObject renderObject, int n, int n2, int n3, int n4) {
        if (renderObject.isVisible(n, n2, n3, n4)) {
            if (this.size >= this.buffer.length) {
                this.increaseBuffer();
            }
            TMPElement tMPElement = this.buffer[this.size];
            tMPElement.obj = renderObject;
            tMPElement.tex = null;
            ++this.size;
        }
    }

    private void increaseBuffer() {
        TMPElement[] tMPElementArray = new TMPElement[this.buffer.length + 30];
        System.arraycopy(this.buffer, 0, tMPElementArray, 0, this.buffer.length);
        for (int i = this.buffer.length; i < tMPElementArray.length; ++i) {
            tMPElementArray[i] = new TMPElement();
        }
        this.buffer = tMPElementArray;
    }

    void sort() {
        int[] nArray = sort;
        int n = 0;
        while (nArray[n] < this.size) {
            ++n;
        }
        while (--n >= 0) {
            int n2;
            for (int i = n2 = nArray[n]; i < this.size; ++i) {
                TMPElement tMPElement = this.buffer[i];
                int n3 = tMPElement.obj.sz;
                for (int j = i; j >= n2 && this.buffer[j - n2].obj.sz < n3; j -= n2) {
                    this.buffer[j] = this.buffer[j - n2];
                }
                this.buffer[j] = tMPElement;
            }
        }
    }

    public void reset() {
        this.size = 0;
    }

    public void resetTex() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i].tex = null;
        }
    }

    TMPElement[] getBuffer() {
        return this.buffer;
    }

    public int getSize() {
        return this.size;
    }
}

