/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Morphing;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.Matrix;

public class BoundingBox {
    private Vertex[] vertices;
    private int minx;
    private int miny;
    private int maxx;
    private int maxy;
    private int minz;

    public BoundingBox(Mesh mesh) {
        this.set(mesh.minX(), mesh.minY(), mesh.minZ(), mesh.maxX(), mesh.maxY(), mesh.maxZ());
    }

    public BoundingBox(Morphing morphing) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        short[][] sArray = morphing.getVertices();
        for (int i = 0; i < sArray.length; ++i) {
            short[] sArray2 = sArray[i];
            for (int j = 0; j < sArray2.length / 3; ++j) {
                short s = sArray2[j * 3];
                short s2 = sArray2[j * 3 + 1];
                short s3 = sArray2[j * 3 + 2];
                n = Math.min(n, s);
                n2 = Math.min(n2, s2);
                n3 = Math.min(n3, s3);
                n4 = Math.max(n4, s);
                n5 = Math.max(n5, s2);
                n6 = Math.max(n6, s3);
            }
        }
        this.set(n, n2, n3, n4, n5, n6);
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.vertices = new Vertex[]{new Vertex(n, n2, n3), new Vertex(n4, n2, n3), new Vertex(n, n2, n6), new Vertex(n4, n2, n6), new Vertex(n, n5, n3), new Vertex(n4, n5, n3), new Vertex(n, n5, n6), new Vertex(n4, n5, n6)};
    }

    public boolean isVisible(Graphics3D graphics3D, Matrix matrix, int n, int n2, int n3, int n4) {
        graphics3D.transformAndProjectVertices(this.vertices, matrix);
        Vertex vertex = this.vertices[0];
        this.minx = this.maxx = vertex.sx;
        this.miny = this.maxy = vertex.sy;
        this.minz = vertex.rz;
        for (int i = 1; i < this.vertices.length; ++i) {
            vertex = this.vertices[i];
            if (vertex.sx < this.minx) {
                this.minx = vertex.sx;
            }
            if (vertex.sy < this.miny) {
                this.miny = vertex.sy;
            }
            if (vertex.rz < this.minz) {
                this.minz = vertex.rz;
            }
            if (vertex.sx > this.maxx) {
                this.maxx = vertex.sx;
            }
            if (vertex.sy <= this.maxy) continue;
            this.maxy = vertex.sy;
        }
        return this.maxx >= n && this.minx <= n3 && this.maxy >= n2 && this.miny <= n4 && this.minz < 0;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public int getMinX() {
        return this.minx;
    }

    public int getMinY() {
        return this.miny;
    }

    public int getMinZ() {
        return this.minz;
    }

    public int getMaxX() {
        return this.maxx;
    }

    public int getMaxY() {
        return this.maxy;
    }
}

