/*
 * Decompiled with CFR 0.152.
 */
package com.demo;

import com.demo.GameScreen;
import com.demo.Main;
import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.Texture;
import com.iceberg.graphics3d.Vertex;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class Logo
extends Canvas {
    private boolean run = false;
    private Thread thread = null;
    private Graphics3D g3d;
    private Polygon4V[] effList;
    private float scale = 1.0f;
    private Texture logo;
    private Texture glide;
    private Polygon4V logoRender;
    protected final int width;
    protected final int height;
    private long lastTime;
    private Main main;

    public Logo(Main main) {
        this.setFullScreenMode(true);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.main = main;
        this.g3d = new Graphics3D(this.width, this.height);
        this.logo = Main.asset.getTexture("/logo.png");
        this.glide = Main.asset.getTexture("/glide.png");
        this.scale = (float)(this.width + this.height) / 560.0f;
        int n = this.width / 2;
        int n2 = this.height / 2;
        int n3 = (int)(120.0f * this.scale);
        float f = (float)this.width / (float)this.height;
        float f2 = Main.aspectRatio;
        if (f2 < 1.0f) {
            f2 = 1.0f / f2;
        }
        if (f < 1.0f) {
            f = 1.0f / f;
        }
        int n4 = (int)((float)n3 * 1.3333334f * (f /= f2));
        this.logoRender = new Polygon4V(new Vertex(n - n4, n2 - n3, 0), 0, 0, new Vertex(n + n4, n2 - n3, 0), -1, 0, new Vertex(n + n4, n2 + n3, 0), -1, -1, new Vertex(n - n4, n2 + n3, 0), 0, -1);
        int n5 = (int)(8.0f * this.scale);
        n4 = ((int)(320.0f / Main.aspectRatio * this.scale) - 240) * 320 / 240 / 2;
        n3 = ((int)(240.0f * this.scale) - 240) / 2;
        this.effList = new Polygon4V[30];
        for (int i = 0; i < 30; ++i) {
            Random random = new Random();
            random.setSeed(i);
            int n6 = Math.abs(random.nextInt()) % (int)(427.0f * this.scale * f);
            n6 = (int)((float)n6 + ((float)this.width - 240.0f * Main.aspectRatio) / 2.0f);
            n5 = (int)((float)(i / 2 + 8) * this.scale);
            random = new Random();
            random.setSeed(i + 30);
            int n7 = Math.abs(random.nextInt()) % this.height;
            this.effList[i] = new Polygon4V(new Vertex((int)((float)n6 - (float)n5 * f), n7 - n5 * 2, 0), 0, 0, new Vertex((int)((float)n6 + (float)n5 * f), n7 - n5 * 2, 0), 64, 0, new Vertex((int)((float)n6 + (float)n5 * f), n7, 0), 64, 64, new Vertex((int)((float)n6 - (float)n5 * f), n7, 0), 0, 64);
        }
        if (Main.music) {
            main.playMusic("/Music.mp3");
        }
        this.lastTime = Main.beginTime = System.currentTimeMillis();
    }

    private void render() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        float f = (float)this.width / (float)this.height;
        float f2 = Main.aspectRatio;
        if (f2 < 1.0f) {
            f2 = 1.0f / f2;
        }
        if (f < 1.0f) {
            f = 1.0f / f;
        }
        f /= f2;
        this.g3d.clear(0xFFFFFF);
        long l = System.currentTimeMillis();
        this.logoRender.render(this.g3d, this.logo);
        int n6 = (int)(l - this.lastTime);
        int n7 = (int)(8.0f * this.scale);
        int n8 = (int)((float)(5L * (l - this.lastTime)) * this.scale / 100.0f);
        for (int i = 0; i < 30; ++i) {
            Polygon4V polygon4V = this.effList[i];
            if (polygon4V.a.sy > this.height && polygon4V.b.sy > this.height && polygon4V.c.sy > this.height && polygon4V.d.sy > this.height) {
                Random random = new Random();
                random.setSeed(i);
                n5 = Math.abs(random.nextInt()) % (int)(427.0f * this.scale * f);
                n5 = (int)((float)n5 + ((float)this.width - 240.0f * Main.aspectRatio) / 2.0f);
                n7 = (int)((float)(i / 2 + 8) * this.scale);
                polygon4V.a.set2((int)((float)n5 - (float)n7 * f), -n7 * 2, 0);
                polygon4V.b.set2((int)((float)n5 + (float)n7 * f), -n7 * 2, 0);
                polygon4V.c.set2((int)((float)n5 + (float)n7 * f), 0, 0);
                polygon4V.d.set2((int)((float)n5 - (float)n7 * f), 0, 0);
            }
            n4 = (i - 15) / 4;
            polygon4V.a.sx += (n4 += (polygon4V.a.sx - this.height / 2) * 2 / this.width) * n8 / 2;
            polygon4V.b.sx += n4 * n8 / 2;
            polygon4V.c.sx += n4 * n8 / 2;
            polygon4V.d.sx += n4 * n8 / 2;
            polygon4V.a.sy += n8;
            polygon4V.b.sy += n8;
            polygon4V.c.sy += n8;
            polygon4V.d.sy += n8;
            polygon4V.render(this.g3d, this.glide, (byte)4);
        }
        if (l - Main.beginTime < 2000L) {
            int[] nArray = this.g3d.display;
            int n9 = 255 - (int)(l - Main.beginTime) * 255 / 2000;
            n4 = 255 - n9;
            n5 = 0xFF00FF * n9;
            n3 = 65280 * n9;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                nArray[n2] = ((n & 0xFF00FF) * n4 + n5 & 0xFF00FF00 | (n & 0xFF00) * n4 + n3 & 0xFF0000) >>> 8;
            }
        }
        if (l - Main.beginTime > 5800L) {
            int[] nArray = this.g3d.display;
            int n10 = (int)(l - Main.beginTime - 5800L) * 255 / 4000;
            if (n10 > 255) {
                n10 = 255;
            }
            n4 = 255 - n10;
            n5 = 0 * n10;
            n3 = 0 * n10;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                nArray[n2] = ((n & 0xFF00FF) * n4 + n5 & 0xFF00FF00 | (n & 0xFF00) * n4 + n3 & 0xFF0000) >>> 8;
            }
        }
        this.lastTime = l;
    }

    protected void paint(Graphics graphics) {
        if (System.currentTimeMillis() - Main.beginTime > 9800L) {
            for (int i = 0; i < 30; ++i) {
                Polygon4V polygon4V = this.effList[i];
                polygon4V.a = null;
                polygon4V.b = null;
                polygon4V.c = null;
                polygon4V.d = null;
                polygon4V = null;
            }
            this.effList = null;
            Main.asset.remove("/logo.png");
            this.logo = null;
            this.glide = null;
            this.logoRender.a = null;
            this.logoRender.b = null;
            this.logoRender.c = null;
            this.logoRender.d = null;
            this.logoRender = null;
            this.g3d.destroy();
            this.g3d = null;
            System.gc();
            this.main.setCanvas(new GameScreen(this.main));
        } else {
            this.render();
            this.g3d.flush(graphics, 0, 0, this.height);
            this.repaint();
        }
    }
}

