/*
 * Decompiled with CFR 0.152.
 */
package com.demo;

import com.demo.GameScreen;
import com.demo.Main;
import com.iceberg.graphics3d.Fps;
import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.MultyTexture;
import com.iceberg.graphics3d.Polygon3V;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Sprite;
import com.iceberg.graphics3d.TMPElement;
import com.iceberg.graphics3d.Texture;
import com.iceberg.math.Matrix;
import com.objects.Camera;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class GreetingsScreen
extends Canvas {
    private Graphics3D g3d;
    private long usmem = 0L;
    private int width;
    private int height;
    private long lastTime = 0L;
    private boolean keyUp = false;
    private boolean keyDown = false;
    private boolean keyLeft = false;
    private boolean keyRight = false;
    private int key;
    private long curTime = 0L;
    private boolean moved = true;
    private Matrix look;
    private Camera cam;
    private Texture[] sprites;
    private TMPElement[] objects;
    private Mesh[] models;
    private MultyTexture tex;
    private GameScreen gs;
    private Main main;
    private long lastCheck = 0L;
    private long beginn = 0L;

    public GreetingsScreen(GameScreen gameScreen, Main main, Graphics3D graphics3D, Matrix matrix, Camera camera) {
        try {
            RenderObject renderObject;
            RenderObject renderObject2;
            int n;
            this.setFullScreenMode(true);
            this.models = Main.asset.getMeshes_iceberg("/cc/CC.3d", 1, 1, 1);
            int n2 = 22;
            this.sprites = new Texture[n2];
            this.tex = new MultyTexture(new Texture[]{Main.asset.getTexture("/cc/floor.png", true), new Texture(new int[]{0}, 1, 1), new Texture(new int[]{0x404040}, 1, 1)}, false);
            this.models[0].setTexture(this.tex);
            this.models[1].setTexture(this.tex);
            this.models[2].setTexture(this.tex);
            this.models[3].setTexture(this.tex);
            RenderObject[] renderObjectArray = this.models[3].getPolygons();
            for (n = 0; n < renderObjectArray.length; ++n) {
                renderObject2 = renderObjectArray[n];
                if (renderObject2 instanceof Polygon3V) {
                    renderObject = (Polygon3V)renderObject2;
                    renderObject.mode = (byte)8;
                }
                if (!(renderObject2 instanceof Polygon4V)) continue;
                renderObject = (Polygon4V)renderObject2;
                ((Polygon4V)renderObject).mode = (byte)8;
            }
            renderObjectArray = this.models[1].getPolygons();
            for (n = 0; n < renderObjectArray.length; ++n) {
                renderObject2 = renderObjectArray[n];
                if (renderObject2 instanceof Polygon3V) {
                    renderObject = (Polygon3V)renderObject2;
                    renderObject.mode = (byte)8;
                }
                if (!(renderObject2 instanceof Polygon4V)) continue;
                renderObject = (Polygon4V)renderObject2;
                ((Polygon4V)renderObject).mode = (byte)8;
            }
            renderObjectArray = this.models[2].getPolygons();
            for (n = 0; n < renderObjectArray.length; ++n) {
                renderObject2 = renderObjectArray[n];
                if (renderObject2 instanceof Polygon3V) {
                    renderObject = (Polygon3V)renderObject2;
                    renderObject.mode = (byte)8;
                }
                if (!(renderObject2 instanceof Polygon4V)) continue;
                renderObject = (Polygon4V)renderObject2;
                ((Polygon4V)renderObject).mode = (byte)8;
            }
            for (n = 0; n < n2; ++n) {
                this.sprites[n] = Main.asset.getTexture("/cc/" + n + ".png", false);
            }
            this.objects = new TMPElement[90];
            for (n = 0; n < this.objects.length; ++n) {
                renderObject2 = new Sprite(this.sprites[0], 10, GreetingsScreen.getRandom(-20000, 30000, n * 3), GreetingsScreen.getRandom(1500, 14000, n * 3 + 1), GreetingsScreen.getRandom(-16000, 20000, n * 3 + 2));
                ((Sprite)renderObject2).setOffset(0, -320);
                ((Sprite)renderObject2).lowq = false;
                this.objects[n] = new TMPElement();
                this.objects[n].obj = renderObject2;
                this.objects[n].tex = this.sprites[0];
            }
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.gs = gameScreen;
            this.main = main;
            this.g3d = graphics3D;
            this.look = matrix;
            this.cam = camera;
            this.cam.x = 0;
            this.cam.y = 0;
            this.cam.z = 0;
            this.cam.angle = 0;
            this.look.setIdentity();
            this.look.rotY(33);
            this.look.rotX2(55);
            this.look.setPosition(13783, 28731, 13809);
            this.cam.set2(this.look);
            this.lastTime = Main.beginTime;
            this.g3d.setPerspective(10000);
            Graphics3D.drawDist = 80000000;
            this.beginn = System.currentTimeMillis();
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void render() {
        this.g3d.clear(0xFFFFFF);
        this.g3d.setCamera(this.cam.getCamera());
        for (int i = 0; i < this.objects.length; ++i) {
            ((Sprite)this.objects[i].obj).project(this.g3d, this.g3d.getInvCamera());
            this.g3d.addRenderObject(this.objects[i]);
        }
        this.models[1].project(this.g3d, this.g3d.getInvCamera());
        this.g3d.addMesh(this.models[1]);
        if (this.curTime - Main.beginTime <= 52000L) {
            this.models[0].project(this.g3d, this.g3d.getInvCamera());
            this.g3d.addMesh(this.models[0]);
            this.models[0].offsetSz(-80000);
            this.models[2].project(this.g3d, this.g3d.getInvCamera());
            this.g3d.addMesh(this.models[2]);
            this.models[3].project(this.g3d, this.g3d.getInvCamera());
            this.g3d.addMesh(this.models[3]);
        }
        this.g3d.render();
    }

    protected void update() {
        int n;
        int n2;
        if (this.curTime - Main.beginTime < 46000L) {
            n2 = (int)(this.curTime - this.beginn);
            this.look.setIdentity();
            this.look.rotY(33);
            this.look.rotX2(55 - Math.min(103, n2 * 103 / 1500));
            if (n2 > 1500) {
                this.look.rotX2((n2 - 1500) / 350);
            }
            this.look.setPosition(13783, 28731 - n2, 13809);
            if (this.moved) {
                this.cam.set2(this.look);
                this.moved = false;
            }
        }
        if (this.curTime - Main.beginTime >= 46000L && this.curTime - Main.beginTime < 48800L) {
            n2 = (int)(this.curTime - Main.beginTime - 46000L);
            this.look.setIdentity();
            this.look.rotY(-42);
            this.look.rotX2(-40);
            this.look.setPosition(-20449 + n2 / 3, 15946, 15911);
            if (!this.moved) {
                this.g3d.setPerspective(16000);
                this.moved = true;
                this.cam.set2(this.look);
            }
        }
        if (this.curTime - Main.beginTime >= 48800L && this.curTime - Main.beginTime < 52000L) {
            n2 = (int)(this.curTime - Main.beginTime - 48800L);
            this.look.setIdentity();
            this.look.rotY(-49);
            this.look.setPosition(-8904 + n2 / 3, 2412, 6532);
            if (this.moved) {
                this.g3d.setPerspective(14900);
                this.moved = false;
                this.cam.set2(this.look);
            }
        }
        if (this.curTime - Main.beginTime >= 52000L && this.curTime - Main.beginTime < 57500L) {
            n2 = (int)(this.curTime - Main.beginTime - 49000L);
            this.look.setIdentity();
            this.look.rotY(-55);
            this.look.rotX2(-55);
            this.look.setPosition(-2948, 14792 + n2 / 2, -4064);
            if (!this.moved) {
                this.g3d.setPerspective(14500);
                this.moved = true;
                this.cam.set2(this.look);
                this.objects = new TMPElement[90];
                for (n = 0; n < this.objects.length; ++n) {
                    int n3 = GreetingsScreen.getRandom(1, this.sprites.length, n * 4);
                    Sprite sprite = new Sprite(this.sprites[n3], 30, GreetingsScreen.getRandom(-7000, 7000, n * 16275 / 361), GreetingsScreen.getRandom(3000, 19000, n * 57679 / 423), GreetingsScreen.getRandom(0, -12000, n * 23647 / 281));
                    sprite.setOffset(0, -120);
                    sprite.lowq = false;
                    this.objects[n] = new TMPElement();
                    this.objects[n].obj = sprite;
                    this.objects[n].tex = this.sprites[n3];
                }
            }
        }
        if (this.curTime - Main.beginTime >= 57500L && this.curTime - Main.beginTime < 63000L) {
            n2 = (int)(this.curTime - Main.beginTime - 57500L);
            this.look.setIdentity();
            this.look.rotY(-112);
            this.look.rotX2(-6);
            this.look.setPosition(-8290, 11793 + n2 / 2, -9042);
            if (this.curTime - Main.beginTime >= 61000L) {
                n = (int)(this.curTime - Main.beginTime - 61000L);
                this.look.rotX2(n / 3000);
                this.look.setPosition(-8290, 11793 + n2 / 2 + n * 10, -9042);
            }
            if (this.moved) {
                this.moved = false;
                this.cam.set2(this.look);
            }
        }
        this.cam.set(this.look);
        if (this.curTime - this.lastCheck > 1000L) {
            this.usmem = Runtime.getRuntime().totalMemory() / 1024L - Runtime.getRuntime().freeMemory() / 1024L;
            this.lastCheck = this.curTime;
        }
        this.lastTime = this.curTime;
    }

    public void paint(Graphics graphics) {
        int n;
        this.curTime = System.currentTimeMillis();
        this.update();
        if (this.curTime - Main.beginTime < 63000L) {
            this.render();
            n = this.height / 2 - this.g3d.getHeight() / 2;
            this.g3d.flush(graphics, 0, n, this.getHeight());
            graphics.setColor(0xFF0000);
            Fps.fps();
            this.repaint();
        }
        if (this.curTime - Main.beginTime >= 63000L) {
            int n2 = 22;
            for (n = 0; n < n2; ++n) {
                this.sprites[n] = null;
                Main.asset.remove("/cc/" + n + ".png");
            }
            this.models[0].setTexture();
            this.models[1].setTexture();
            this.models[2].setTexture();
            this.models[3].setTexture();
            for (n = 0; n < this.objects.length; ++n) {
                ((Sprite)this.objects[n].obj).setTexture(null);
                this.objects[n].tex = null;
                this.objects[n].obj = null;
            }
            this.models = null;
            Main.asset.remove("/cc/CC.3d");
            Main.asset.remove("/cc/floor.png");
            this.tex.destroy();
            this.g3d.buffer.reset();
            this.g3d.buffer.resetTex();
            System.gc();
            this.main.setCanvas(this.gs);
        }
    }

    protected void keyPressed(int n) {
        this.key = n;
        if (!Main.landspace) {
            if (n == 50 || n == -1) {
                this.keyUp = true;
            }
            if (n == 56 || n == -2) {
                this.keyDown = true;
            }
            if (n == 52 || n == -3) {
                this.keyLeft = true;
            }
            if (n == 54 || n == -4) {
                this.keyRight = true;
            }
        } else {
            if (n == 54 || n == -4) {
                this.keyUp = true;
            }
            if (n == 52 || n == -3) {
                this.keyDown = true;
            }
            if (n == 50 || n == -1) {
                this.keyLeft = true;
            }
            if (n == 56 || n == -2) {
                this.keyRight = true;
            }
        }
        if (n == -8) {
            // empty if block
        }
    }

    protected void keyReleased(int n) {
        this.key = 0;
        if (!Main.landspace) {
            if (n == 50 || n == -1) {
                this.keyUp = false;
            }
            if (n == 56 || n == -2) {
                this.keyDown = false;
            }
            if (n == 52 || n == -3) {
                this.keyLeft = false;
            }
            if (n == 54 || n == -4) {
                this.keyRight = false;
            }
        } else {
            if (n == 54 || n == -4) {
                this.keyUp = false;
            }
            if (n == 52 || n == -3) {
                this.keyDown = false;
            }
            if (n == 50 || n == -1) {
                this.keyLeft = false;
            }
            if (n == 56 || n == -2) {
                this.keyRight = false;
            }
        }
    }

    private void keyAction() {
        if (this.keyUp) {
            this.look.rotX2(-5);
        }
        if (this.keyDown) {
            this.look.rotX2(5);
        }
        if (this.keyLeft) {
            this.look.rotY(-5);
        }
        if (this.keyRight) {
            this.look.rotY(5);
        }
        if (this.key == 55) {
            this.look.addPosition(0, 25, 0);
        }
        if (this.key == 57) {
            this.look.addPosition(0, -25, 0);
        }
        if (this.key == 49) {
            this.cam.z += 50;
        }
        if (this.key == 51) {
            this.cam.z -= 50;
        }
    }

    public static int getRandom(int n, int n2, int n3) {
        Random random = new Random();
        random.setSeed(System.currentTimeMillis() + (long)n3);
        if (n < n2) {
            return n + random.nextInt(Math.abs(n2 - n));
        }
        return n - random.nextInt(Math.abs(n2 - n));
    }
}

