#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;





vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

float sdCylinder( vec3 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

#define PI 3.1415


vec3 evaluateLight(vec3 p)
{	
	/*if (p.x == 0.0) {
		p.x = 0.00001;
	}
	float angle = atan(p.y, p.x);
	float numParts = 6.0;
	float partSize = PI / numParts;
	angle += PI;
	float part = floor(angle / partSize);
	angle = mod(angle + iGlobalTime * 0.3, partSize) + partSize * 0.5 * max(0.0, numParts - 1.0);
	float len = length(p.xy);
	vec3 newPos = vec3(len * cos(angle), len * sin(angle), p.z);
	float dis =  sdCylinder(newPos, vec3(0.0, 0.0, 0.5));*/


	float numParts = 10;
	float partSize = PI / numParts;


	float angleo = atan(p.y, p.x) + PI;
	float angle = mod(angleo, partSize)  + partSize * 0.5 * max(0.0, numParts - 1.0);

	float angleYZ = atan(length(p.xy) * sin(angle), p.z) + PI;
	float partYZ = floor(angleYZ / partSize);


	float ring = partYZ * 0.5;
	float numPartsYZ = 10; // bero p partYZ
	if (abs(ring - 5.0) < 0.001) {
		numPartsYZ = 2.0;
	}
	if (abs(ring - 5.5) < 0.001) {
		numPartsYZ = 5.0;
	}
	float partSizeYZ = PI / numPartsYZ;
	float partXY = floor(angleo / partSizeYZ);
	angle = mod(angleo, partSizeYZ)  + partSizeYZ * 0.5 * max(0.0, numPartsYZ - 1.0);
	float len = length(p.xy);
	vec3 intermediatePos = vec3(len * cos(angle), len * sin(angle), p.z);

	angleYZ = atan(intermediatePos.y, intermediatePos.z) +  PI;
	partYZ = floor(angleYZ / partSizeYZ);

	angleYZ = mod(angleYZ, partSize) + partSize * 0.5 * max(0.0, numParts - 1.0);
	float lenYZ = length(intermediatePos.yz);
	vec3 finalPos = vec3(intermediatePos.x, lenYZ * sin(angleYZ), lenYZ * cos(angleYZ));


	float rs = 1.0;
	//finalPos.y = mod(finalPos.y , rs) - rs/2.0;


	float dis = sdCappedCylinder(finalPos, vec2(0.5, 1000.0));
	//float dis = udRoundBox(finalPos, vec3(0.3), 0.2);
	float part = mix(partXY, partYZ, 0.5);


	vec3 lightColor = 3000.0 * normalize(vec3(0.4 + 0.4 * sin(part), 0.4 + 0.4 * sin(part * 0.5 + 1.0), 0.4 + 0.4 * sin(part * 0.25 + 2.0)));
	vec3 lightPos = vec3(0.0, 0.0, 0.0);
	vec3 l = lightPos - finalPos;
	float disToLight = length(l);
	vec3 pointLight = lightColor * 1.0 / (disToLight * disToLight);
	vec3 lnorm = l / disToLight;
	return pointLight * clamp(-dis, 0.0, 1.0) + pointLight * 0.00;
}

float map(vec3 p) {
	return length(p) - 2.0;
}

vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz).x - map(p - ep.xyz).x;
    normal.y = map(p + ep.yxz).x - map(p - ep.yxz).x;
    normal.z = map(p + ep.yzx).x - map(p - ep.yzx).x;
    return normalize(normal);

}

vec3 raymarch(vec3 ro, vec3 rd, inout vec3 finalPos)
{
	float t = 0.0;
    const int maxIter = 100;
    
    float part = -1.0;

    vec3 scatteredLight = vec3(0.0);
    float transmittance = 1.0;
    float fogAmount = 0.06;
    float minDistance = 0.0;
    vec3 p = vec3(-1.0, -1.0, -1.0);
    for (int i = 0; i < maxIter; i++) {
        p = ro + rd * t;


        vec3 light = evaluateLight(p);
        vec3 lightIntegrated = light - light * exp(-fogAmount * minDistance);
        scatteredLight += transmittance * lightIntegrated;

        transmittance *= exp(-fogAmount * minDistance);

//        minDistance = map(p);
//        minDistance = min(0.5, minDistance);
        minDistance = 0.5;
        if (minDistance < 0.2) {
        	break;
        }
        t += minDistance;
    }
    finalPos = p;
    //return part;
    return scatteredLight;
}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
 	vec3 eye = vec3(sin(iGlobalTime * 1.0) * 15.0 , cos(iGlobalTime * 1.0) * 15.0, 40);
    vec3 tar = eye + vec3(0.0, 0.0, 0.1);
   	tar = vec3(0, 0, 0);
    vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir)); 
 	vec3 up = cross(dir, right);
    
	vec3 ro = eye;	
    vec3 rd = normalize(dir + right*u + up*v);
    
    vec3 light = vec3(0.0, 20.0, -20.0);
    
    vec3 finalPos = vec3(-1.0, -1.0, -1.0);
    vec3 scatteredLight = raymarch(ro, rd, finalPos);


    fragColor = vec4(scatteredLight, 1.0);
}

void main()
{
	mainImage(fragColor, fragCoord);
}
