#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

//////////////////////////////////////////////////////


vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}



#define TEX 0.1
#define SIZE 8.0
float map(vec3 p) {
	float s = SIZE;
	vec3 q = vec3(mod(p.x, s) - s * 0.5, p.y, mod(p.z, s) - s * 0.5);
	vec3 normal = normalize(q);
	//float t = texCube(iChannel1, p * TEX, normal, 1 ).x;
	//t -= 0.5;
//	float h = t * 0.2;
	return udRoundBox(q, vec3(s * 0.2), s * 0.05);// - h;
//	vec3 d = abs(q) - vec3(s * 0.2);
//	return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));// + h;
}

float raymarch(vec3 ro, vec3 rd, inout vec3 finalPos) {
	float t = 0.0;
	const int maxIter = 1000;
	const float maxDis = 3000.0;
	float d = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	float mat = -1;
	for (int i = 0; i < maxIter; i++) {
		p = ro + rd * t;
		
		
		d = map(p);
		if (d < 0.01) {
			mat = 1;
			break;
		}
		t += d;
		if (t > maxDis) {
			break;
		}
	}
	finalPos = p;
	return mat;
}

vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz) - map(p - ep.xyz);
    normal.y = map(p + ep.yxz) - map(p - ep.yxz);
    normal.z = map(p + ep.yzx) - map(p - ep.yzx);
    return normalize(normal);

}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
    vec3 eye = vec3(20.0 + iGlobalTime * 1.0, 10.0, 20.0 + iGlobalTime * 1.0);
	vec3 tar = eye + vec3(0.0, -1.0, 1.0);

	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 20.0, -20.0);

	vec3 finalPos = vec3(-1.0, -1.0, -1.0);
	float material = -1.0;
	float mat = raymarch(ro, rd, finalPos);
	vec3 color = vec3(0.0, 0.0, 0.0);
	if (mat > 0) {
		vec3 normal = getNormal(finalPos);
		color = texCube(iChannel0, finalPos * TEX, normal, 1 ).xyz;
		vec3 invLight = normalize(light - finalPos);
		float diffuse = max(0.0, dot(invLight, normal));
		color = 0.7 * color * (1.0 + diffuse);
		color += specular(normal, -invLight, normalize(eye - finalPos), 70.0) * (1.0 - smoothstep(20.0, 100.0, eye.y));
	}
    fragColor = vec4(color, 1.0);
}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
