#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
/////////////////////////////////////////////////////
#define MAT_SAND 1.0
#define MAT_SKY 2.0
#define MAT_PYR 3.0


#define EPS 0.01
float sdBox( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

vec2 un(vec2 dm1, vec2 dm2) {
	return dm1.x < dm2.x ? dm1 : dm2;
}

vec2 sand(vec3 pos) {
	float h = texture(iChannel0, pos.xz * 0.025).x * 1.0;
	return vec2(pos.y - h, MAT_SAND);
}

float pyrField(vec2 p, float base, float h )
{
	vec2 pyr = min(mod(p, base), base -  mod(p, base));
	return min(pyr.x, pyr.y) * h;
}
float pyramid(vec2 p, float base, float h )
{
	vec2 pyr = min(p, base - p);
	return min(pyr.x, pyr.y) * h;
}

vec2 pyr(vec3 pos) {
	float h = pos.y - pyramid(ivec2(pos.xz), 30.0, 1.0);
	if (h < 0.0) {
		float d = udRoundBox(mod(pos, 1.0) - 0.5, vec3(0.3), 0.2);
		return vec2(d, MAT_PYR);
	} else {
		return vec2(max(EPS, h * 0.1), -1.0);
	}
	
}

vec2 map(vec3 pos) {
	vec2 dm = vec2(99999999.0, -1.0);
	dm = un(dm, sand(pos));
	dm = un(dm, pyr(pos));
	return dm;
}





float raymarch(vec3 ro, vec3 rd, inout vec3 finalPos) {
	float t = 0.0;
	const int maxIter = 600;
	const float maxDis = 500.0;
	float material = MAT_SKY;
	float d = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	for (int i = 0; i < maxIter; i++) {
		p = ro + rd * t;
		vec2 dm = map(p);
		d = dm.x;

		if (dm.x < EPS) {
			material = dm.y;
			break;
		}
		t += d;
		if (t > maxDis) {
			break;
		}
	}
	finalPos = p;
	return material;
}

vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz).x - map(p - ep.xyz).x;
    normal.y = map(p + ep.yxz).x - map(p - ep.yxz).x;
    normal.z = map(p + ep.yzx).x - map(p - ep.yzx).x;
    return normalize(normal);

}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

vec3 applyFog(vec3 rgb, float dis, vec3 rayDir, vec3 sunDir, vec3 p)
{
	float disFog = 1.0 - exp(-dis*0.01);
	float heightFog = 0.0;//1 - smoothstep(0.0, 2.0, p.y);
	float fogAmount = max(disFog, heightFog);
	float sunAmount = max(0.0, dot(rayDir, sunDir));
	vec3 fogColor = mix(vec3(0.8), vec3(1.0,0.9,0.7), pow(sunAmount, 8.0)); // 12.0
	return mix(rgb, fogColor, fogAmount);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
    vec3 eye = vec3(0.0, 5.0, -200.0 + iGlobalTime);
	vec3 tar = eye + vec3(0.0, 0.0, 1.0);

	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 20.0, -20.0);

	vec3 color = vec3(0.5, 0.0, 0.5);
	vec3 finalPos = vec3(-1.0, -1.0, -1.0);
	float material = raymarch(ro, rd, finalPos);
	bool lightning = true;
	float spec = 1.0;
    if (material ==  MAT_SAND) {
    	color = vec3(0.9, 0.6, 0.3);
    	spec = 0.1;
    } else if (material == MAT_SKY) {
   	 	lightning = false;
    	color = vec3(0.0, 0.0, 1.0);
    } else if (material == MAT_PYR) {
    	color = vec3(1.0, 0.8, 0.4);
    }
	vec3 invLight = normalize(light - finalPos);
    if (lightning) {
	    vec3 normal = getNormal(finalPos);
		float diffuse = max(0.0, dot(invLight, normal));
		color = 0.7 * color * (1.0 + diffuse);
		color += spec * specular(normal, -invLight, normalize(eye - finalPos), 70.0);
    }
    color =  applyFog(color, distance(eye, finalPos), rd, invLight, finalPos);
    
    
    fragColor = vec4(color, 1.0);
}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
