#version 330

in vec2 TexCoords;


out vec4 outColor;
uniform sampler2D modelTexture;
uniform int RESOLUTION_WIDTH;
uniform int RESOLUTION_HEIGHT;
//#define compactKeys  10
//uniform float midi[10 * compactKeys];
uniform float drum;
uniform float iGlobalTime;

vec3 laplacian(vec3 center, vec3 up, vec3 down, vec3 right, vec3 left, vec3 upLeft, vec3 upRight, vec3 downLeft, vec3 downRight)
{

	return 9*center - 1*(up + down + right + left + upLeft + upRight + downLeft + downRight);
}

vec3 blur2(vec3 center, vec3 up, vec3 down, vec3 right, vec3 left, vec3 upLeft, vec3 upRight, vec3 downLeft, vec3 downRight)
{
	return 1.0/9.0*(center + up + down + right + left + upLeft + upRight + downLeft + downRight);
}

vec3 blur(vec3 center, vec3 up, vec3 down, vec3 right, vec3 left)
{
	return 1.0/5.0*(center + up + down + right + left);
}


vec3 sharpen(vec3 center, vec3 up, vec3 down, vec3 right, vec3 left)
{
	return 5*center -up - left - right - down;
}

vec3 edge(vec3 center, vec3 up, vec3 down, vec3 right, vec3 left)
{
	return (4*center -up - left - right - down);
}


#ifndef FXAA_REDUCE_MIN
    #define FXAA_REDUCE_MIN   (1.0/ 128.0)
#endif
#ifndef FXAA_REDUCE_MUL
    #define FXAA_REDUCE_MUL   (1.0 / 8.0)
#endif
#ifndef FXAA_SPAN_MAX
    #define FXAA_SPAN_MAX     8.0
#endif


vec4 fxaa(sampler2D tex, vec2 fragCoord, vec2 resolution,
            vec2 v_rgbNW, vec2 v_rgbNE,
            vec2 v_rgbSW, vec2 v_rgbSE,
            vec2 v_rgbM) {
    vec4 color;
    mediump vec2 inverseVP = vec2(1.0 / resolution.x, 1.0 / resolution.y);
    vec3 rgbNW = texture2D(tex, v_rgbNW).xyz;
    vec3 rgbNE = texture2D(tex, v_rgbNE).xyz;
    vec3 rgbSW = texture2D(tex, v_rgbSW).xyz;
    vec3 rgbSE = texture2D(tex, v_rgbSE).xyz;
    vec4 texColor = texture2D(tex, v_rgbM);
    vec3 rgbM  = texColor.xyz;
    vec3 luma = vec3(0.299, 0.587, 0.114);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);
    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));

    mediump vec2 dir;
    dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
    dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));

    float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) *
                          (0.25 * FXAA_REDUCE_MUL), FXAA_REDUCE_MIN);

    float rcpDirMin = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);
    dir = min(vec2(FXAA_SPAN_MAX, FXAA_SPAN_MAX),
              max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),
              dir * rcpDirMin)) * inverseVP;

    vec3 rgbA = 0.5 * (
        texture2D(tex, fragCoord * inverseVP + dir * (1.0 / 3.0 - 0.5)).xyz +
        texture2D(tex, fragCoord * inverseVP + dir * (2.0 / 3.0 - 0.5)).xyz);
    vec3 rgbB = rgbA * 0.5 + 0.25 * (
        texture2D(tex, fragCoord * inverseVP + dir * -0.5).xyz +
        texture2D(tex, fragCoord * inverseVP + dir * 0.5).xyz);

    float lumaB = dot(rgbB, luma);
    if ((lumaB < lumaMin) || (lumaB > lumaMax))
        color = vec4(rgbA, texColor.a);
    else
        color = vec4(rgbB, texColor.a);
    return color;
}

void main()
{
	float xd = 1.0/RESOLUTION_WIDTH;
	float yd = 1.0/RESOLUTION_HEIGHT;
	/*vec3 center = texture(modelTexture, TexCoords).xyz;
	vec3 up = texture(modelTexture, vec2(TexCoords.x, TexCoords.y + yd)).xyz;
	vec3 left = texture(modelTexture, vec2(TexCoords.x - xd, TexCoords.y)).xyz;
	vec3 right = texture(modelTexture, vec2(TexCoords.x + xd, TexCoords.y)).xyz;
	vec3 down = texture(modelTexture, vec2(TexCoords.x, TexCoords.y - yd)).xyz;
	vec3 upLeft = texture(modelTexture, vec2(TexCoords.x - xd, TexCoords.y + yd)).xyz;
	vec3 upRight = texture(modelTexture, vec2(TexCoords.x + xd, TexCoords.y + yd)).xyz;
	vec3 downLeft= texture(modelTexture, vec2(TexCoords.x - xd, TexCoords.y - yd)).xyz;
	vec3 downRight = texture(modelTexture, vec2(TexCoords.x + xd, TexCoords.y - yd)).xyz;

	vec3 lap = laplacian(center, up, down, right, left, upLeft, upRight, downLeft, downRight);
	vec3 blu = blur(center, up, down, right, left, upLeft, upRight, downLeft, downRight);
	float r = (lap.x + lap.y + lap.z)/3.0;
*/

	vec2 resolution = vec2(RESOLUTION_WIDTH, RESOLUTION_HEIGHT);
	vec2 inverseVP = 1.0 / resolution.xy;
	vec2 v_rgbNW = (TexCoords + vec2(-1.0, -1.0)) * inverseVP;
	vec2 v_rgbNE = (TexCoords + vec2(1.0, -1.0)) * inverseVP;
	vec2 v_rgbSW = (TexCoords + vec2(-1.0, 1.0)) * inverseVP;
	vec2 v_rgbSE = (TexCoords + vec2(1.0, 1.0)) * inverseVP;
	vec2 v_rgbM =  vec2(TexCoords * inverseVP);


	vec4 texCol = texture2D(modelTexture, v_rgbM);
	vec4 fxaCol =  fxaa(modelTexture, TexCoords, resolution, v_rgbNW, v_rgbNE, v_rgbSW, v_rgbSE, v_rgbM);

    vec3 rgbNW = texture2D(modelTexture, v_rgbNW).xyz;
    vec3 rgbNE = texture2D(modelTexture, v_rgbNE).xyz;
    vec3 rgbSW = texture2D(modelTexture, v_rgbSW).xyz;
    vec3 rgbSE = texture2D(modelTexture, v_rgbSE).xyz;
    vec4 texColor = texture2D(modelTexture, v_rgbM);

	//vec3 tr = vec3(edge(texColor.xyz, rgbNW, rgbNE, rgbSW, rgbSE).x);
//	vec3 tr = edge(texColor.xyz, rgbNW, rgbNE, rgbSW, rgbSE);
	vec3 tr = pow(texColor.xyz, vec3(3.0));
//	fxaCol.xyz = pow( fxaCol.xyz, vec3(0.4545) );
	vec3 dis = texture2D(modelTexture, v_rgbM + vec2(0.01*length(v_rgbM) * drum, 0)).xyz;
	vec3 dis2 = texture2D(modelTexture, v_rgbM + vec2(-0.01*length(v_rgbM) * drum, 0)).xyz;
//	outColor = vec4(mix(tr, fxaCol.xyz, 1-midi[75]), 1.0);
	outColor = vec4(vec3(drum > 0.01 ? dis2.x : fxaCol.x, drum > 0.01 ? dis.y : fxaCol.y, fxaCol.z), 1.0);
//	float ratio = float(RESOLUTION_WIDTH) / float(RESOLUTION_HEIGHT);
//	if (abs(v_rgbM.y * 2.0 - 1.0) > ratio / (16.0/9.0)) {
//		outColor = vec4(0,0,0,1);
//	}
//	if (abs(v_rgbM.y * 2.0 - 1.0) > ratio / (16.0/9.0)) {
//		outColor = vec4(0,0,0,1);
//	}
}




