#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
/////////////////////////////////////////////////////

float hash( in vec2 p ) {
	float h = dot(p,vec2(127.1,311.7));	
    return fract(sin(h)*43758.5453123);
}

float noise( in vec2 p ) {
    vec2 i = floor( p );
    vec2 f = fract( p );	
	vec2 u = f*f*(3.0-2.0*f);
    return mix( mix( hash( i + vec2(0.0,0.0) ), 
                     hash( i + vec2(1.0,0.0) ), u.x),
                mix( hash( i + vec2(0.0,1.0) ), 
                     hash( i + vec2(1.0,1.0) ), u.x), u.y);
}

float noiseOctave(in vec2 p, int octaves, float persistence)
{
	float n = 0;
	float amplitude = 1;
	float frequency = 1;
	float maxValue = 0;

	for(int i = 0; i < octaves; i++)
	{
		n += noise((p+i) * frequency) * amplitude;
		maxValue += amplitude;
		amplitude *= persistence;
		frequency *= 2.0;
	}
	return n / maxValue; 
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	vec2 uv = vec2(fragCoord / iResolution) * 2.0 - 1.0;
	uv.y *= iResolution.y/iResolution.x;
    float n = noiseOctave(uv * 4, 10, 0.7);
    
    fragColor = vec4(vec3(n), 1.0);

}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
