#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;



vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdCylinder( vec3 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}


vec2 map(vec3 p)
{	
	/*p.y += sin(p.x * 2.0 + iGlobalTime * 1.0);
	p.x += sin(p.y * 5.0 + iGlobalTime * 1.3);
	p.z += sin(p.y * 3.0 + iGlobalTime * 1.7);*/
	
	float r = length(p) * (1.3 + 0.3 * sin(p.y + iGlobalTime));
	float phi = acos(p.z / r);
	float theta = atan(p.y, p.x);
	
	p.x += 0.7 * sin(theta * 3.0 + phi * 2.5 + iGlobalTime * 1.0);
	p.z += 0.7 * sin(theta * 5.0 + phi * 1.5 + iGlobalTime * 3.3);
	p.y += 0.7 * cos(theta * 7.0 + phi * 6.5 + iGlobalTime * 2.7);
	
	/*float x = r * sin(phi) * cos(theta);
	float y = r * sin(phi) * sin(theta);
	float z = r * cos(phi);*/
	
	p.y += 0.2 * sin(p.x * 2.0 + iGlobalTime * 0.1);
	p.x += 0.2 * sin(p.y * 5.0 + iGlobalTime * 0.3);
	p.z += 0.2 * sin(p.y * 3.0 + iGlobalTime * 0.7);
	
	
	
	//float dis = length(p - vec3(0.0 ,0.0, 0.0)) - 6.0;
	float dis = udRoundBox(p, vec3(1.5), 3.0);
	return vec2(dis, 0.5);
}

float raymarch(vec3 ro, vec3 rd, inout vec3 finalPos) 
{
	float t = 0.0;
    const int maxIter = 150;
    
    float material = 0.0;
    
    vec3 p = vec3(-1.0, -1.0, -1.0);
    for (int i = 0; i < maxIter; i++) {
        p = ro + rd * t;

    	vec2 dm = map(p);
        if (dm.x < 0.01) {
        	material = dm.y;
        	break;
        }
        t += dm.x * 0.4;
    }
    finalPos = p;
    return material;
}

vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz).x - map(p - ep.xyz).x;
    normal.y = map(p + ep.yxz).x - map(p - ep.yxz).x;
    normal.z = map(p + ep.yzx).x - map(p - ep.yzx).x;
    return normalize(normal);

}




float occlusion(vec3 p, vec3 normal)
{
	float o = 2*map(p + normal * 0.5).x;
	return 0.7 + 0.3*o;
}



float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
 	vec3 eye = vec3(10.0, 10.0 , 10.0);
   // vec3 tar = eye + vec3(0.0, 0.0, 0.1);
   	vec3 tar = vec3(0, 0, 0);
    vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir)); 
 	vec3 up = cross(dir, right);
    
	vec3 ro = eye;	
    vec3 rd = normalize(dir + right*u + up*v);
    
    vec3 light = vec3(0.0, 20.0, -20.0);
    
    vec3 finalPos = vec3(-1.0, -1.0, -1.0);
    float material = raymarch(ro, rd, finalPos);
   	vec3 color = vec3(0.5, 0.0, 0.2);
	vec3 normal = getNormal(finalPos);
	vec3 invLight = normalize(light - finalPos);
	invLight = normalize(vec3(0.6,0.7,0));
  	float diffuse = max(0.0, dot(invLight, normal));
  	if (material <= 0.0) {
		color = vec3(0);
  	} else {
  		color = texCube(iChannel0, finalPos, normal, 0.5).xyz;
  	}
	color *= occlusion(finalPos, normal);
	//color = vec3(occlusion(finalPos, normal));
	color = 0.7 * color * (1.0 + diffuse);
    color += specular(normal, -invLight, normalize(eye - finalPos), 70.0);
 
    fragColor = vec4(color, 1.0);
}

void main()
{
	mainImage(fragColor, fragCoord);
}
