#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;


uniform float drum;
uniform float incDrum;
//////////////////////////////////////////////////////
vec2 un(vec2 a, vec2 b)
{
	return a.x < b.x ? a : b;
}



float water(vec3 p, vec3 rd)
{
	if(rd.y > 0){ // verkar som detta ger smre performance
		return 999999;
	}
	float t = iGlobalTime * 0.5;

	float d = (sin(p.x + t*0.5) + sin(p.z  + t*0.5)) * 0.1 +
			length(texture(iChannel0, p.xz*0.25 + vec2(0, t*0.1)))*0.1 +
			length(texture(iChannel0, p.xz*0.25 + vec2(t*0.13, 0)))*0.1;
	d *= 0.2;

	float h = p.y - d * 0.1;

	float dis = (0.1 -p.y)/rd.y;

	return max(h, dis);
}

//vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
//{
//	vec4 x = texture2D( sam, p.yz );
//	vec4 y = texture2D( sam, p.zx );
//	vec4 z = texture2D( sam, p.xy );
//    vec3 w = pow( abs(n), vec3(k) );
//	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
//}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

//float sdCappedCylinder( vec3 p, vec2 h )
//{
//  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
//  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
//}

vec4 rick(vec3 pos, vec3 rd)
{
	pos.xy *= 1.2;
	int partZ = int((pos.z + 50) / 100);
	pos.z = mod(pos.z+50, 100) - 50;

	vec3 d = vec3(0.1, 0.1, 0.5);
	vec3 q = mod(pos, d) - 0.5 * d;

	vec3 s = (d * 0.5 -  sign(rd)* q) / abs(rd);
	vec2 part = floor(pos.xy / d.xy);
	float dx = udRoundBox(pos - vec3(0.3, -0.5, 0), vec3(3.15,0.6,3.1), 0);
	if(dx > 0.01)
		return vec4(dx,0,0,0);

//	if (pos.x < -3 || pos.x > 3 /*|| iGlobalTime < 2*/) {
//		return vec4(999999,0,0,0);
//	}
	float music = drum; //midi[46];
	//0 12 28
	float[3] off = float[3](0, 12, 28);
	pos.xy = mod(pos.xy, d.xy) - d.xy * 0.5;
	vec3 c =  texture2D( iChannel1, vec2(part.x + 30, -part.y +off[partZ % 3]) / 64.0).xyz;

	float dis = udRoundBox(pos, vec3(0.025, 0.025, 0+ music), 0.01);
	float b = min(s.x, min(s.y, s.z));
	if(c.x == 1.0){
		dis = max(b + 0.01, dis);
	}
//	c = vec3(sin(part.x / 5.0 + iGlobalTime * 3.0) * 0.3 + 0.4, sin(part.y / 10.0 + iGlobalTime * 2.0) * 0.3 + 0.4, 0.6);
	c = vec3(0.7 + 0.3 * music * 0.8,  music * 0.4 ,0.7 + 0.3* music);
	return vec4(dis, c);
}

#define TEX 0.2
#define SIZE 8.0
#define PI 3.1415

vec4 map(vec3 p, vec3 rd, inout float ref, bool inRef) {
	p.x = p.x == 0 ? 0.00001 : p.x;

	float angle = atan(p.y, p.x);
	float numParts = 14.0;
	float partSize = PI / numParts;
	angle += PI;
	float part = floor(angle / partSize);
	angle = mod(angle, partSize) + partSize * 0.5 * max(0.0, numParts - 1.0);
	float len = length(p.xy);
	float zd = 1.0;
	float zpart = floor(p.z / zd);
	vec3 newPos = vec3(len * cos(angle), (len-5 + sin(zpart*10 + part*5 + iGlobalTime*2)* 0.05) * sin(angle), mod(p.z, zd) - zd * 0.5);
	float dis = udRoundBox(newPos, vec3(0.41), 0.1);
//	vec3 col = vec3(sin(part*0.5), sin(zpart*0.5), sin(part + zpart));
//	col += vec3(1.5);
//	col *= vec3(0.5);
//	col = mix(col, vec3(0), 0.5);
	vec3 col = vec3(0.2 + 0.8*mod(part, 2.0));
	float r = 0.0;
	if (!inRef) {
		float wdis = water(p - vec3(0, -1.2, 0), rd);
		if (wdis < dis) {
			dis = wdis;
			col = vec3(0, 0, 1);
			r = 1.0;
		}
	}
	vec4 rc = rick(p - vec3(0,0.5,15), rd);

	if(rc.x < dis){
		dis = rc.x;
		col = rc.yzw;
		r = 0.5;
	}
	ref = r;
	return vec4(dis, col);
//	return sdCappedCylinder(newPos, vec2(0.5, 1.0));
}

vec4 map(vec3 p, vec3 rd, inout float ref) {
	return map(p, rd, ref, false);
}

vec4 roofLight(vec3 p) {
	p.y -= 3.5;
	float music = drum; //midi[46];
	float s = 4.0;
//	vec3 q = mod(p, s) - s * 0.5;
	p.z = mod(p.z, s) - s * 0.5;
//	q.y = p.y;
//	q.x = p.x;
	vec3 lightCol = vec3(1.0, 0.5, 1.0);
	float dis = length(p) - 0.1;
	float distanceToL = max(0.0001, dis);
	vec3 point = lightCol * 15.0/(distanceToL*distanceToL);

	return vec4(point, distanceToL);
}


vec3 evaluateLight(vec3 pos, inout float dis)
{
	vec4 rl = roofLight(pos);
	dis = rl.w;
	return rl.xyz;
}


vec3 getNormal(vec3 p, vec3 rd)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    float ref = 0;
    normal.x = map(p + ep.xyz, rd, ref).x - map(p - ep.xyz, rd, ref).x;
    normal.y = map(p + ep.yxz, rd, ref).x - map(p - ep.yxz, rd, ref).x;
    normal.z = map(p + ep.yzx, rd, ref).x - map(p - ep.yzx, rd, ref).x;
    return normalize(normal);

}



float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

void addLightning(inout vec3 color, vec3 normal, vec3 eye, vec3 pos) {
	vec3 o = pos;
	pos.z = mod(pos.z+50, 100) - 50;
	vec3 lpos = vec3(0,0,12 );

	float dis = length(lpos - pos);
	vec3 invLight = normalize(lpos - pos);
	float diffuse = max(0.0, dot(invLight, normal));
	float spec = specular(normal, -invLight, normalize(eye - o), 220.0);

	float str = 1.0/(0.1 + 0.1*dis + 0.02*dis*dis);
	color =  color * (0.3 + 0.5*diffuse) + spec;
	color = clamp(color, vec3(0), vec3(1));
	color *= str;
	float tmp = 0;
//	color += evaluateLight(o, tmp).xyz;
}

float occlusion(vec3 p, vec3 normal, vec3 rd)
{
	float ref = 0;
	float o = clamp(2*map(p + normal * 0.5, rd, ref).x, 0, 1);
	return 0.5 + 0.5*o;
}


vec3 raymarch(vec3 ro, vec3 rd, vec3 eye) {
	float t = 0.0;
	const int maxIter = 600;
	const float maxDis = 300.0;
	float d = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	vec3 col = vec3(0);
	const int jumps = 2;
	float ref = 1.0;
	vec3 scatteredLight = vec3(0.0);
	float transmittance = 1.0;
//	for (int j = 0; j < jumps; j++) {
	bool inRef = false;
		for (int i = 0; i < maxIter; i++) {
			p = ro + rd * t;

			float rr = 0;
			vec4 res = map(p, rd, rr, inRef);
			d = res.x;
			float fogAmount = 0.01 + smoothstep(28,33,iGlobalTime) *2.5;
			float lightDis = -1.0;
			vec3 light = evaluateLight(p, lightDis);
			d = min(min(d, 1), max(lightDis, 0.05)); //1 0.05
			vec3 lightIntegrated = light - light * exp(-fogAmount * d);
			scatteredLight += transmittance * lightIntegrated;
			transmittance *= exp(-fogAmount * d);

			t += d;
			float m = res.y;
			bool end = i == maxIter - 1 ||t > maxDis;
			if (d < 0.01 || end) {
				vec3 c = vec3(1);
				vec3 normal = getNormal(p, rd);
				c = res.yzw;
//				if (rr < 0.1) {
//					c = mix(res.yzw, texCube(iChannel1, p * 0.1, getNormal(p, rd), 10).xyz, 0.75);
//				}

				if (rr != 0.5) {
					c *= occlusion(p, normal, rd);
				}
				addLightning(c, normal, eye, p);
				if (end) {
					transmittance = 0;
				}
				col = mix(col, transmittance * c + scatteredLight, ref);
				 if (rr <= 0.8) {
//					ref = 0.0;
					return col;
				}
				ref *= 0.95;
				inRef = true;
				rd = reflect(rd, getNormal(p, rd));
				ro = p + rd*0.05;
				t = 0;
				i = 0;
//				break;
			}
			if (t > maxDis) {
				return col;
			}
		}

		if (ref < 0.1) {
			return col;
//			break;
		}
//	}
	return col;
}


void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (9.0/ 16.0);//* (iResolution.y/iResolution.x);
    
//    if (u > 0.1) {
//    	u += -0.15;
//    	v *= smoothstep(0.0, 0.1, u) * 0.5 + 0.5;
//    }

    float speed = 5 * iGlobalTime;
    float pz =  -60 + iGlobalTime + smoothstep(0, 5,iGlobalTime) * 60  + smoothstep(10,15, iGlobalTime)*90 + smoothstep(20,25, iGlobalTime)*90;
//    pz = 10;
    vec3 eye = vec3(0, 0, pz);
//    if (iGlobalTime > 10) {
//    	 eye = mix(eye, vec3(0, 0 , -50 + iGlobalTime), 1-smoothstep(10,11,iGlobalTime));
//    }
	vec3 tar = eye + vec3(0,0,1);//vec3(sin(iGlobalTime * 0.2) * 0.03, 0.0, 1.0);

	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 0.0, 26.0 );

	float material = -1.0;
	vec3 color = raymarch(ro, rd, eye);
//	if (color != vec3(0)) {
//		vec3 normal = getNormal2(finalPos, rd);
//		color *= occlusion(finalPos, normal, rd);
//		addLightning(color, normal, eye, finalPos);
//	}

//	vec2 uv = 2.6*vec2(u+0.1,-v-0.223);
//	vec3 tex = texture(iChannel3, uv).xyz;
//	if (uv.x > 1.0 || uv.x < 0.0 || uv.y > 0.0 || uv.y < -1.0 ) {
//		tex = vec3(0);
//	}
//    fragColor = vec4(mix(color, tex, 1-smoothstep(2,5,iGlobalTime)), 1.0);
    fragColor = vec4(mix(vec3(0), color, smoothstep(0, 1, iGlobalTime)), 1.0);
    fragColor.rgb = fragColor.rgb / (fragColor.rgb + vec3(1.0));
}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
