typedef struct
{
        unsigned char measure;
        unsigned char beat;
        unsigned char subdivision;
} time;

typedef struct
{
        //both measured in samples
        time start; 
        time stop;

        unsigned char note;
        unsigned char instrument;
} note;   

static long timeToClock ( time * t )
{
        return (long) ((t->measure * BEATS_PER_MEASURE + t->beat + t->subdivision / 256.0f )
                * ( 60.0f / TEMPO * SAMPLE_RATE));
}


