// Rock joka tiesi... liikaa!

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define SCREEN 0x1000

#define waitline(x) while(*(unsigned char *)0x9004!=(x))
#define setbgborder(x) *(char *)0x900f=((x)+8)

extern unsigned char frameintro[];
extern unsigned char frame0000[];
extern unsigned char piisi[];

// Kbd defines
#define SPACE  0xef,1
#define LSHIFT 0xf7,2
#define RSHIFT 0xef,64
#define DOWN   0xf7,128
#define RIGHT  0xfb,128

// Music "routine"
unsigned char *ptr=piisi;
void play()
{
	unsigned char c,here;

	here=*ptr++;
	if(here==255)
	{
		ptr=piisi;
		here=*ptr++;
	}

	if(here&1) *(unsigned char *)(0x9000+10)=*ptr++;
	if(here&2) *(unsigned char *)(0x9000+11)=*ptr++;
	if(here&4) *(unsigned char *)(0x9000+12)=*ptr++;
	if(here&8) *(unsigned char *)(0x9000+13)=*ptr++;
	if(here&16) *(unsigned char *)(0x9000+14)=*ptr++;
}

char getkey(unsigned char col,unsigned char row)
{
	*(char *)0x9120=col;
	return ((*(char *)0x9121)^255) & row;
}

char remap[256];

// Remaps a full charset to less
void movechars(char *s,int n)
{
	int i,count=0,c;

	for(i=0;i<256;i++)
		remap[i]=255;

	for(i=0;i<n;i++)
	{
		if(remap[s[i]]==255)
		{
			c=s[i];
			remap[c]=count;

			// AE and OE
			if(c==129 || c==143)
			{
				c-=128;
				memcpy((void *)(0x1400+(count<<3)),(void *)(0x8000+(c<<3)),8);
				*(char *)(0x1400+(count<<3))=0x5a;
			}
			else
				memcpy((void *)(0x1400+(count<<3)),(void *)(0x8000+(c<<3)),8);

			s[i]=count;
			count++;
		}
		else
			s[i]=remap[s[i]];
	}
}

int main(void)
{
	int x,y,j,k;
	char *s,stopped=0,i;
	signed char scrolling=0;
	asm("sei");

	*(char *)0x9005=0xc0;

	movechars(frame0000,68*88);

	// Fade border to white
	for(i=154;i!=0;i--)
	{
		waitline(0);
		setbgborder(0x13);
		waitline(i);
		setbgborder(0x11);
	}

	// Lame fade out
	for(x=0;x<2000;x++)
	{
		j=rand()&511; // Painfully slow, I'm sure :/
		*(char *)(SCREEN+j)=32;
	}
	memset((char *)SCREEN,32,506);
	for(i=0;i<25;i++)
	{
		waitline(1);
		waitline(2);
	}

	// Title screen, set char fgs to black
	memset((void *)0x9400,0,506);

	x=21*22;
	for(y=0;y<22;y++,x-=22)
	{
		waitline(138);
		waitline(137);
		memcpy((char *)(SCREEN+x),&frameintro[x],22);
	}

	while(!getkey(SPACE))
		;

	// Text must go
	x=22*22;
	for(y=0;y<23;y++,x-=22)
	{
		waitline(138);
		waitline(137);
		memset((char *)(SCREEN+x),32,22);
	}

	// Switch to the other charset
	memset((char *)SCREEN,remap[32],506);
	*(char *)0x9005=0xcd;

	// Another lame fade in
	for(x=0;x<2200;x++)
	{
		// Probably pretty slow...
		j=rand()&511;
		k=j%22+j/22*68;

		*(char *)(SCREEN+22+j)=frame0000[k];
	}

	// Sound on
	*(char *)(0x9000+14)=12;

	// Main loop
	y=x=0;
	while(1)
	{
		waitline(130);
		setbgborder(0x11);
		play();

		// Read keyz
		if(getkey(LSHIFT) || getkey(RSHIFT))
		{
			if(getkey(RIGHT) && x>0)
				x--;
			if(getkey(DOWN))
			{
				if(!stopped)
					scrolling=-1;
			}
			else
			{
				if(stopped)
				{
					stopped=0;
					scrolling=0;
				}
			}
		}
		else
		{
			if(getkey(RIGHT) && x<46*2)
				x++;
			if(getkey(DOWN))
			{
				if(!stopped)
					scrolling=1;
			}
			else
			{
				if(stopped)
				{
					stopped=0;
					scrolling=0;
				}
			}
		}

		// Scrolling logic
		if(scrolling==1 && !stopped)
		{
			y+=68;
			if(y==68*22 || y==68*44) { stopped=1; }
			if(y==68*67) { y-=68; stopped=1; }
		}
		if(scrolling==-1 && !stopped)
		{
			y-=68;
			if(y==68*22 || y==68*44) { stopped=1; }
			if(y==-68) { y+=68; stopped=1; }
		}

		// Copy position and scroll register
		s=frame0000+(x>>1)+y;
		*(char *)0x9000=0xc-(x&1);

		// Kinda slow but let's leave it as is
		memcpy((void *)(SCREEN+22),s,22);
		memcpy((void *)(SCREEN+44),s+68,22);
		memcpy((void *)(SCREEN+66),s+136,22);
		memcpy((void *)(SCREEN+88),s+204,22);
		memcpy((void *)(SCREEN+110),s+272,22);

		memcpy((void *)(SCREEN+132),s+340,22);
		memcpy((void *)(SCREEN+154),s+408,22);
		memcpy((void *)(SCREEN+176),s+476,22);
		memcpy((void *)(SCREEN+198),s+544,22);
		memcpy((void *)(SCREEN+220),s+612,22);

		memcpy((void *)(SCREEN+242),s+680,22);
		memcpy((void *)(SCREEN+264),s+748,22);
		memcpy((void *)(SCREEN+286),s+816,22);
		memcpy((void *)(SCREEN+308),s+884,22);
		memcpy((void *)(SCREEN+330),s+952,22);

		memcpy((void *)(SCREEN+352),s+1020,22);
		memcpy((void *)(SCREEN+374),s+1088,22);
		memcpy((void *)(SCREEN+396),s+1156,22);
		memcpy((void *)(SCREEN+418),s+1224,22);
		memcpy((void *)(SCREEN+440),s+1292,22);

		memcpy((void *)(SCREEN+462),s+1360,22);
		memcpy((void *)(SCREEN+484),s+1428,22);

		//setbgborder(0x10);
		setbgborder(0x11);
	}

	return 0;
}
