import os
import cPickle

from drawingutils import Brush

ioPath = os.path.abspath('shoutouts_arrow_anim.pickle')


def export():
    from maya import cmds
    from maya.OpenMaya import MSelectionList, MGlobal, MDagPath, MItMeshPolygon, MIntArray, MPointArray

    def isVisible(node):
        if not cmds.objExists(node + '.visibility'):
            return False
        if not cmds.getAttr(node + '.visibility'):
            return False
        if cmds.objExists(node + '.intermediateObject'):
            if cmds.getAttr(node + '.intermediateObject'):
                return False
        if cmds.objExists(node + '.overrideEnabled'):
            if cmds.getAttr(node + '.overrideEnabled') and \
                    not cmds.getAttr(node + '.overrideVisibility'):
                return False
        parent = cmds.listRelatives(node, p=True, f=True)
        if parent:
            return isVisible(parent[0])
        return True

    def meshTriangulation(mesh):
        li = MSelectionList()
        MGlobal.getSelectionListByName(mesh, li)
        p = MDagPath()
        li.getDagPath(0, p)
        iter = MItMeshPolygon(p)
        out_triangulation = []
        while not iter.isDone():
            triangles = MIntArray()
            iter.getTriangles(MPointArray(), triangles)
            for i in xrange(triangles.length()):
                out_triangulation.append(triangles[i])
            iter.next()
        return out_triangulation

    # get visible meshes
    meshData = []
    for mesh in cmds.ls(type='mesh', ni=True, l=True):
        if not isVisible(mesh):
            continue
        meshData.append([mesh, meshTriangulation(mesh), []])

    # sample mesh vertex positions along the time range
    start = int(cmds.playbackOptions(q=True, min=True))
    end = int(cmds.playbackOptions(q=True, max=True))
    for frame in xrange(start, end + 1):
        cmds.currentTime(frame)
        for i in xrange(len(meshData)):
            points = cmds.xform(meshData[i][0] + '.vtx[*]', q=True, ws=True, t=True)
            if frame == start:
                for j in xrange(len(points) / 3):
                    # we populate the meshData for mesh i with a list for each point
                    meshData[i][2].append([[frame] + points[j * 3:j * 3 + 3]])
            else:
                for j in xrange(len(meshData[i][2])):
                    # we append each point's list with the next frame, resulting in having a construct like this:
                    # for mesh in meshData:
                    #     for point in mesh[2]:
                    #         for x, y, z in points:

                    meshData[i][2][j].append([frame] + points[j * 3:j * 3 + 3])

    # optimize all point frames
    def norm3(x, y, z):
        f = (x * x + y * y + z * z) ** 0.5
        if f:
            f = 1.0 / f
            return x * f, y * f, z * f
        return 0, 0, 0

    def dot3(a, b):
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2]

    def diffKeys(a, b, c):
        f = dot3(norm3(b[1] - a[1], b[2] - a[2], b[3] - a[3]),
                 norm3(c[1] - a[1], c[2] - a[2], c[3] - a[3]))
        EPSILON = 0.01
        if abs(f - 1) < EPSILON:
            return True
        return False

    for i in xrange(len(meshData)):
        print meshData[i][0]
        for j in xrange(len(meshData[i][2])):
            for frame in xrange(len(meshData[i][2][j]) - 2, 0, -1):
                if diffKeys(meshData[i][2][j][frame - 1],
                            meshData[i][2][j][frame],
                            meshData[i][2][j][frame + 1]):
                    meshData[i][2][j].pop(frame)

    with open(ioPath, 'w') as fh:
        cPickle.dump(meshData, fh)


def load():
    with open(ioPath) as fh:
        return cPickle.load(fh)


def sample(meshData, time, buffer, offset, color, zoom, speed, bindings={}):
    OFFSETX = 120 + offset[0]
    OFFSETY = 65 + offset[1]

    def _sampleAnim(pointAnim, time, zoom, speed):
        time *= speed
        for j in xrange(len(pointAnim)):
            key = pointAnim[j]
            if key[0] > time:
                prev = pointAnim[j - 1]
                w = (time - prev[0]) / float(key[0] - prev[0])
                return (int(round((prev[1] * (1.0 - w) + key[1] * w) * zoom + OFFSETX)),
                        int(round((prev[3] * (1.0 - w) + key[3] * w) * zoom + OFFSETY)))
        return int(round(pointAnim[len(pointAnim) - 1][1] * zoom + OFFSETX)), int(round(pointAnim[len(pointAnim) - 1][3] * zoom + OFFSETY))

    for i in xrange(len(meshData)):
        mesh, triangles, pointAnims = meshData[i]

        # gather animated points
        points = []
        for pointAnim in pointAnims:
            points.append(_sampleAnim(pointAnim, time, zoom, speed))

        # read triangle indices and draw them at the right place
        for i in xrange(0, len(triangles), 3):
            coords = (points[triangles[i]][0], points[triangles[i]][1],
                      points[triangles[i + 1]][0], points[triangles[i + 1]][1],
                      points[triangles[i + 2]][0], points[triangles[i + 2]][1])

            # see if there is a color / brush override
            if mesh in bindings:
                brush = bindings[mesh]
            else:
                brush = color

            # call right draw method if a brush is used
            # TODO: UV exporting from maya
            if isinstance(brush, Brush):
                # hack assuming quad uvs for the shoutouts here
                coords += (0.0, 0.0, 0.0, 1.0, 1.0, 0.0) if i == 0 else (1.0, 0.0, 0.0, 1.0, 1.0, 1.0)
                buffer.drawTriangle(brush, *coords)
            else:
                buffer.drawTriangleI(brush, *coords)
