import os
import struct
import ctypes

WORKING_DIR = os.path.dirname(__file__)
IMAGES_DIR = os.path.abspath('images')
IMAGES_EXT = '.jeMoeder'

IMAGES = {}
def get_image(name):
    if name not in IMAGES:
        file_path = r'%s\%s%s'%(IMAGES_DIR, name, IMAGES_EXT)
        with open(file_path, 'rb') as fh:
            width = struct.unpack('<L', fh.read(4))[0]
            height = struct.unpack('<L', fh.read(4))[0]
            read = fh.read()
            image = struct.unpack('<%sL' % (width * height), read )
            image = (ctypes.c_int * (width * height))(*image)
        IMAGES[name] = image, width, height
    return IMAGES[name]

