from shader_base import Shader
from math import atan2, sin 


def frac(x):
    if x < 0:
        return -frac(-x)
    return x - int(x)


def triangle(x):
    return 2.0 * abs(frac(abs(x)) - 0.5)


def scale3(color, factor):
    return color[0] * factor, color[1] * factor, color[2] * factor


def mix3(a, b, w):
    return (b[0] - a[0]) * w + a[0], (b[1] - a[1]) * w + a[1], (b[2] - a[2]) * w + a[2]


class Tunnel(Shader):
    def __init__(self, *args, **kwargs):
        super(Tunnel, self).__init__(*args, **kwargs)
        self.fade = kwargs.get("fade", 0)
        self.fade_color = (0.0, 0.5, 1.0)

    def pre_sample(self, alive):
        return (self._width / float(self._height),)

    def sample(self, alive, u, v, *args):
        self.fade = min(2, alive)
        # convert to proper tunnel UVs
        u, v = (u * 2.0 - 1.0) * args[0], v * 2.0 - 1.0
        u, v = (u * u + v * v), atan2(u, v)

        fog = min(5, u)

        # apply some texture
        u = pow(u, 0.35) * 2.5  #+ sin(alive)*0.3
        v = v * 4  + (sin(alive)*0.7)
        o = int(v + 0.5) % 2.0
        r1 = min(triangle(u - alive + o * 0.5) * 4.0, 1.0)
        r2 = min(triangle(v) * 2.5, 1.0)
        r = min(r1, r2)
        result = r, r, r

        result = scale3(result, fog)

        # apply fade
        if u > self.fade:
            factor = min((u - self.fade), 1.0)
            return mix3(result, self.fade_color, factor)

        return result
