from effect_base import Effect
import image
from math import atan2, sin, cos, sqrt
import random 
def frac(x):
    if x < 0:
        return -frac(-x)
    return x - int(x)


def triangle(x):
    return 2.0 * abs(frac(abs(x)) - 0.5)


def scale3(color, factor):
    return color[0] * factor, color[1] * factor, color[2] * factor


def mix3(a, b, w):
    return (b[0] - a[0]) * w + a[0], (b[1] - a[1]) * w + a[1], (b[2] - a[2]) * w + a[2]


class SkyVortex(Effect):
    def __init__(self, width, height):
        super(SkyVortex, self).__init__(width, height)
        self._blending= True 
        self.fade_color = (0.0, 0.5, 1.0)

        self._pre = self._width / float(self._height)
        self._chance = -0.01 
    def render(self, alive, delta_time, buffer):
        """
        :type buffer: drawingutils.SmartBuffer
        """

        clouds = image.get_image('clouds'), image.get_image('clouds2')
        repeat = clouds[0][1] * 2 + self._width, clouds[1][1] * 2 + self._width

        buffer.fillRectangleI(clouds[0][0][0], 0, 0, self._width, self._height)

        settings = ((0, 30, 200, 10), (1, 20, 0, 80), (1, 25, 450, 10))
        for setting in settings:
            x = (alive * setting[1] + setting[2]) % repeat[setting[0]] - clouds[setting[0]][1]
            pixels, width, height = clouds[setting[0]]
            buffer.drawImage(int(x), setting[3], width, height, pixels[0], pixels)

        ih = 2.0 / float(self._height)
        ar = self._width / float(self._height)
        iw = 2.0 * ar / float(self._width)
        ihpi = 0.5 / 3.14159265359
        for y in xrange(self._height):
            _v = y * ih - 1.0
            for x in xrange(self._width):
                zoom = 1
                if random.random() < self._chance:
                   self._blending = True 
                   if self._chance > 1 and zoom < 10:
                       zoom = self._chance
                else:
                    self._blending = False 

                if self._blending: 
                    fade = 5
                    minFade = 0.5
                    falloffFactor = 0.2
                    u = x * iw - ar
                    u, v = (u * u + _v * _v)*(5*zoom), atan2(u, _v)# * ihpi + 0.5

                    # apply fade
                    a = 1
                    if u > fade:
                        factor = u - fade
                        if factor > fade*falloffFactor:
                            continue 
                        a = 1-factor/(fade*falloffFactor)
                    elif u < minFade:
                        factor = minFade - u
                        fIn = 1-factor/minFade
                        if 1-factor/minFade < 0.01:
                            continue 
                        a = fIn

                    fog = min(5, u*0.5)

                    # apply some texture
                    u = pow(u, 0.35) * 2.5  #+ sin(alive)*0.3
                    v = v * 4  + (sin(alive)*0.7)
                    o = int(v + 0.5) % 2.0
                    r1 = min(triangle(u - alive + o * 0.5) * 4.0, 1.0)
                    r2 = min(triangle(v) * 2.5, 1.0)
                    r = min(r1, r2)
                    result = r, r, r

                    result = scale3(result, fog)
 
                    col = list(result )+[a]
                    
                    buffer.setPixelFA(x, y, *col)
                    
                else:
                    u = x * iw - ar

                    # get tunnel UV
                    u, v = (u * u + _v * _v), atan2(u, _v) * ihpi + 0.5

                    # arbitrary noise from center, if > 0.0 don't draw tunnel pixel
                    if cos(max(0.0, 3.14159265359 - u ** 0.5 * 2.0)) - ((u ** 0.5 * 8302.0 + v * 2023.0) % 1.0) > 0.0:
                        continue

                    # set pixel from tunnel effect
                    twirl = (sin((u ** 0.3 * 14.0 + v * 10.0 - alive) * 3.14159265359) * 0.5 + 0.5)
                    if twirl < 0.5:
                        continue
                    buffer.setPixelF(x, y, u * 0.2, u * 0.6, u)
        if alive > 5:
            self._chance += delta_time*0.08