from effect_base import Effect


class RendererSettings(Effect):
    def __init__(self, *args, **kwargs):
        self._pageSwapping = None if not "pageSwapping" in kwargs else kwargs.pop("pageSwapping")
        self._activateSheet = None if not "activateSheet" in kwargs else kwargs.pop("activateSheet")
        super(RendererSettings, self).__init__(*args, **kwargs)

    def render(self, alive, delta_time, buffer):
        if not self._pageSwapping == None: 
            self._renderer._pageSwapping = self._pageSwapping
            self._sheets[buffer.index()].Activate()
        if not self._activateSheet == None: self._renderer.sheets[self._activateSheet].Activate()

        self._clear()

    def _clear(self):
        self._pageSwapping = None
        self._activateSheet = None
