from drawingutils import ColorBrush
from image import get_image
from effect_base import Effect


class MarioSprite(Effect):
    def __init__(self, *args, **kwargs):
        super(MarioSprite, self).__init__(*args, **kwargs)
        self.__state = 0
        self.switchState = False
        self.previous = 0
        self.switchIndex = 0
        self.jump = False
        self.jumpTime = 0
        self.jumpHeights = [4, 12, 16, 12, 4]

    def render(self, alive, delta_time, buffer):
        width = self._width
        height = self._height
        brush = ColorBrush(0.05, 0.05, 0.05)
        buffer.fillRectangle(brush, self._offset[0], self._offset[1], width, height)

        # mario!
        if int(alive / 5) % 2 == 0:
            prefix = "b"
            if self.previous == 1: self.switchState = True
            self.previous = 0
        else:
            prefix = "s"
            if self.previous == 0: self.switchState = True
            self.previous = 1

        if self.switchState and self.switchIndex <= 4:
            prefix = "b"
            if self.switchIndex % 2 == 0: prefix = "s"
            self.switchIndex += 1
        elif self.switchIndex > 4:
            self.switchState = False
            self.switchIndex = 0

        self.__state = (self.__state + 1) % 3
        if self.jump and self.jumpTime <= 4:
            image, img_width, img_height = get_image('%s_jump' % (prefix))
            position = int(width / 2) - img_width / 2, height - img_height - 16 - self.jumpHeights[self.jumpTime]
            self.jumpTime += 1

        elif self.jump and self.jumpTime > 4:
            self.jump = False
            self.jumpTime = 0
            image, img_width, img_height = get_image('%s_walk%s' % (prefix, self.__state + 1))
            position = int(width / 2) - img_width / 2, height - img_height - 16
        else:
            image, img_width, img_height = get_image('%s_walk%s' % (prefix, self.__state + 1))
            position = int(width / 2) - img_width / 2, height - img_height - 16
        buffer.drawImage(self._offset[0]+ position[0], self._offset[1]+position[1], img_width, img_height, 0, image)

        # floor
        image, img_width, img_height = get_image('ground')

        y = height - img_height
        for x in xrange(width / img_width ):
            px = int(x * img_width - (alive * 32) % img_width)
            buffer.drawImage(self._offset[0]+px, self._offset[1]+y, img_width, img_height, 0, image)

        # blocks
        image, img_width, img_height = get_image('bricks')
        y = height - img_height - 48
        x = int(-(alive * 32) % (width + img_width) - img_width)
        if int(x / 48) % 2:
            self.jump = True
        buffer.drawImage(self._offset[0]+x, self._offset[1]+y, img_width, img_height, 0, image)
        buffer.drawImage(self._offset[0]+ int(-(img_width * 2 + alive * 32) % (width + img_width) - img_width),self._offset[1]+ y, img_width, img_height, 0, image)

        image, img_width, img_height = get_image('mystery')
        buffer.drawImage(self._offset[0]+int(-(img_width + alive * 32) % (width + img_width) - img_width), self._offset[1]+y, img_width, img_height, -16711936, image)
