from image import get_image
from effect_base import Effect
from math import floor


class Logo(Effect):
    def __init__(self, *args, **kwargs):
        super(Logo, self).__init__(*args, **kwargs)
        self.__state = 0
        self._passed = 0

    def render(self, alive, delta_time, buffer):
        # poo-brain!
        image, img_width, img_height = get_image('poo_brain_%.2i' % (self.__state + 1))

        self._passed += delta_time
        if self._passed > 0.1:
            self._passed = 0
            self.__state = (self.__state + 1) % 9

        ## Resamples the image to the desired size 
        xSample = img_width / float(self._width)
        ySample = img_height / float(self._height)
        for y in xrange(self._height):
            yPx = int(floor(ySample * y))
            for x in xrange(self._width):
                xPx = int(floor(xSample * x))
                buffer.setPixel(self._offset[0]+x, self._offset[1]+y, image[yPx*img_width + xPx])
        #buffer.DrawImage(self._offset[0], self._offset[1], self._width , self._height, 0, image)
        #return 