from effect_base import Effect
from image import get_image
import ctypes 
import random 
from math import floor 

class LoadImage(Effect):
    def __init__(self, *args, **kwargs):
        super(LoadImage, self).__init__(*args, **kwargs)
        self._image  = get_image(kwargs.get("image", "akihabaraPixelArt") )
        baseN = kwargs.get("seqName", None)
        maxNr = kwargs.get("seqMaxNr", 92)
        self._imageS = []
        if baseN:
            for nr in xrange(1, maxNr):
                self._imageS.append(get_image( baseN + str(nr).zfill(3) ))

        self._static = kwargs.get("static", True )
        self._speed = kwargs.get("speed", 1 )
        self._elapsed = 0 
        self._imgIndex = 0
        
    def render( self, alive, delta_time, buffer):

        if self._static:
            pixels, width, height = self._image
            buffer.drawImage(self._offset[0], self._offset[0], width, height, 0, pixels)
            return 
        else:
            if self._elapsed > self._speed:
                pixels, width, height = self._imageS[self._imgIndex]
                xSample = width / float(self._width)
                ySample = height / float(self._height)
                for y in xrange(self._height):
                    yPx = int(floor(ySample * y))
                    for x in xrange(self._width):
                        xPx = int(floor(xSample * x))
                        buffer.setPixel(self._offset[0]+x, self._offset[1]+y, pixels[yPx*width + xPx])
                #buffer.drawImage(self._offset[0], self._offset[0], width, height, 0, pixels)
                self._imgIndex = (self._imgIndex + 1) % len(self._imageS)

            self._elapsed += delta_time
