from effect_base import Effect

class MultiEffect(Effect):
    def __init__(self, *args, **kwargs):
        super(MultiEffect, self).__init__(*args, **kwargs)
        self._effectList = []
        self._waitList = []
    def addEffect(self, effect, wait = 0 ):
        self._waitList.append( wait )
        self._effectList.append(effect) 

    def render( self, alive, delta_time, buffer):
        i = 0 
        for effect, wait in zip(self._effectList, self._waitList):
            if wait <= 0:
                effect.render(alive, delta_time, buffer)
            else:
                self._waitList[i]-= delta_time
            i += 1

