from effect_base import Effect
from drawingutils import rgb2packedInt
from image import get_image
from math import sin 
import ctypes 
class CloudDraw(Effect):
    def __init__(self, *args, **kwargs):
        super(CloudDraw, self).__init__(*args, **kwargs)
        self._blue= rgb2packedInt(0.0, 0.5, 1.0)
        self._blueList = [1 for x in xrange(self._height*self._width)]
    def render(self, alive, delta_time, buffer):
        
        ## draw rectangle wil nie om een of andere reden. 
        #buffer.drawRectangleI(colorInt=self._blue, x=0, y=0, w=self._width, h=self._height) 
        clouds = get_image('cloud_1'), get_image('cloud_2')
        repeat = clouds[0][1] * 2 + self._width, clouds[1][1] * 2 + self._width

        buffer.fillRectangleI(clouds[0][0][0], 0, 0, self._width, self._height)

        settings = ((0, 30, 200, 10), (1, 20, 0, 80), (1, 25, 450, 10))
        for setting in settings:
            x = (alive * setting[1] + setting[2]) % repeat[setting[0]] - clouds[setting[0]][1]
            pixels, width, height = clouds[setting[0]]
            buffer.drawImage(int(x), setting[3], width, height, pixels[0], pixels)


