#version 130
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
uniform sampler2D iChannel4;
uniform sampler2D iChannel5;
uniform sampler2D iChannel6;
uniform vec2 iResolution;
uniform float iGlobalTime;
uniform float flash;
uniform float rotato;
uniform float poppin;
uniform float iv0logo;
uniform float crtslot_random;
uniform float crtslow_alpha;
uniform float rasternoise;
uniform float skene;

mat2 rotate(float Angle){
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float sdCapsule( vec2 p, vec2 a, vec2 b, float r ) {
    vec2 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return min(floor(length( pa - ba*h ) - r),0.);
}
float triangle( vec2 coord, vec2 pos, float angle, float thick, float size) {
    vec2 original_coord = coord;
    coord += pos;
    coord *= rotate(angle);
    float collision = 0.0;
    collision += sdCapsule( coord, vec2( 0.0, 0.333)*size, vec2( 0.3,-0.2)*size, thick );
    collision += sdCapsule( coord, vec2( 0.0, 0.333)*size, vec2(-0.3,-0.2)*size, thick );
    collision += sdCapsule( coord, vec2( 0.3,-0.2)*size, vec2(-0.3,-0.2)*size, thick );
    return -min(max(-collision,0.0),1.0);
}

vec4 alias() {
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    
    vec2 j = vec2(1.,0.)/ iResolution.xy;
    vec2 k = vec2(0.,1.)/ iResolution.xy;
    
    vec4 d = texture2D(iChannel0,uv)*4. +
            texture2D(iChannel0,uv+j)*2. +
            texture2D(iChannel0,uv+k)*2. +
            texture2D(iChannel0,uv-j)*2. +
            texture2D(iChannel0,uv-k)*2. +
            texture2D(iChannel0,uv+j*2.) +
            texture2D(iChannel0,uv+k*2.) +
            texture2D(iChannel0,uv-j*2.) +
            texture2D(iChannel0,uv-k*2.);
    d /= 16.;
    return d;
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float rand(float co){
    return rand(vec2(co));
}
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}

//Reinhard based tone mapping
vec3 tone(vec3 color, float gamma)
{
    float white = 2.;
    float luma = dot(color, vec3(0.2126, 0.7152, 0.0722));
    float toneMappedLuma = luma * (1. + luma / (white*white)) / (1. + luma);
    color *= toneMappedLuma / luma;
    color = pow(color, vec3(1. / gamma));
    return color;
}


vec2 curve(vec2 uv)
{
    uv = (uv - 0.5) * 2.0;
    uv *= 1.1;  
    uv.x *= 1.0 + pow((abs(uv.y) / 5.0), 2.0);
    uv.y *= 1.0 + pow((abs(uv.x) / 4.0), 2.0);
    uv  = (uv / 2.0) + 0.5;
    uv =  uv *0.92 + 0.04;
    return uv;
}

vec4 magic(  vec2 uv ) {
     vec2 p = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    
     float aspect = iResolution.x / iResolution.y;
        float T=iGlobalTime*0.2;
    vec2 j = vec2(3.,0.)/ iResolution.xy;
    vec2 k = vec2(0.,3.)/ iResolution.xy;
    uv=curve(uv);
    vec2 mm=gl_FragCoord.xy / iResolution.xy;
    mm=curve(mm);
    vec4 C = alias();
        C.rgb = tone(C.rgb,2.1);
        C.rgb *= 1.-pow(length(p.x),12.);
        C.rgb *= 1.-pow(length(p.y),12.);
        C.rgb -= vec3(floor(max( mod(mm.x*640.,32.)-30.,0.)))*length(p.y)*length(p.y)*length(p.y)/7.;
        C.rgb -= vec3(floor(max( mod(mm.y*480.,32.)-30.,0.)))*length(p.y)*length(p.y)*length(p.y)/7.;
        C.rgb=max(C.rgb,vec3(.08,.105,.09));
        vec4 logoivorytex1=texture2D(iChannel2,uv*vec2(1.,-1.));
        C = logoivorytex1*iv0logo + C * (1.-logoivorytex1.w * iv0logo);
        if(crtslow_alpha>0. && crtslow_alpha<2.) {
            C *= (1.+poppin*mod(iGlobalTime*2.,2.)/3.)*max(1.-min(pow(length(uv.y-.5)*10.,4.),1.),0.)*texture2D(iChannel1,uv*vec2(1.,-1.)+vec2(0.,2.0*max(crtslot_random-floor(uv.x*9.),1.5*56./256.)+0.3*rand(121.+floor(uv.x*9.))*max(crtslot_random-floor(uv.x*9.),0.) ) ) * crtslow_alpha * mod(uv.y*240.0,1.);
            C.rgb += vec3(.05,.0,.1)+min(max(floor(mod(uv.x*128.0+uv.y*256.0,3.0)),0.),1.) * max(min(pow(length(uv.y-.5)*.2,2.),1.),0.)*vec3(5.,1.8,.0) * (1.-pow(length(p.x),12.))*(1.-pow(length(p.y),12.));
        }
        if(length(uv.y-.5)>flash ) {
            return vec4(0.,0.,0.,1.);
        }

        if(crtslow_alpha>=2.) 
            C -= texture2D(iChannel3,uv+vec2(0.,0.5+(8./256.)-(32./256.)*mod(floor(iGlobalTime*.5+2.),8.)   ))*max(1.-min(pow(length(uv.y-.5)*24.,12.),1.),0.)*max(sin(uv.y*1400.),0.4);
        if(iGlobalTime>92./2. && iGlobalTime<61.)
            C*=texture2D(iChannel4,mm*.5+vec2(iGlobalTime/24.,0));
        if(iGlobalTime>23. && iGlobalTime<38.5){
            C=vec4(1.0,0.7,0.5,1.0)*texture2D(iChannel5,mm)*length(texture2D(iChannel5,mm).r)+C*(1.-length(texture2D(iChannel5,mm).r));
        }
        return C + vec4(vec3(rand(uv*iGlobalTime)-.5)/32.,0.);
        

}

void main() {
    vec2 uv= gl_FragCoord.xy / iResolution.xy;
    uv.x += (rand(iGlobalTime*uv.y)-.5)*rasternoise;
        vec4 ret = vec4(0.0);
        vec4 tex = vec4(0.0);
        tex = magic( uv+vec2(0.0,-0.001));
        vec3 cyan = tex.rgb*vec3(0.0,1.0,1.0);
        cyan*=1.3;
        cyan=vec3(min(cyan.r,1.0),min(cyan.g,1.0),min(cyan.b,1.0));
        tex = magic( uv+vec2(0.0,0.0001));
        vec3 yellow = tex.rgb*vec3(1.0,1.0,0.0);
        yellow*=1.3;
        yellow=vec3(min(yellow.r,1.0),min(yellow.g,1.0),min(yellow.b,1.0));
        tex = magic( uv+vec2(-0.0001,0.0));
        vec3 magenta = tex.rgb*vec3(1.0,0.0,1.0);
        magenta*=1.3;
        magenta=vec3(min(magenta.r,1.0),min(magenta.g,1.0),min(magenta.b,1.0));
        
        
        float depth = length(tex.rgb);
        depth*=depth;
        
        ret = vec4(cyan+yellow+magenta,1.0)/(2.0+depth/8.0);
        
        
        float aspectCorrection = (iResolution.x/iResolution.y);
        vec2 coordinate_entered = 2.0 * uv - 1.0;
        vec2 coord = vec2(aspectCorrection,1.0) *coordinate_entered;
        ret -= rand(uv*uv+iGlobalTime)/96.;

        if(iGlobalTime>88.)
        ret = texture2D(iChannel6, gl_FragCoord.xy / iResolution.xy);

    gl_FragColor = ret;
}