//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID3050e018_3241_4755_a83c_942db06a249d
{
    public class Class_FaceCamera: OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            //<<< _params

            using (new PropertyStasher<OperatorPartContext>(context, "ObjectTWorld")) {
                var cameraToWorld = context.WorldToCamera;
                cameraToWorld.Invert();
                var newObjectToWorld = context.ObjectTWorld * cameraToWorld;
                newObjectToWorld.Row4 = context.ObjectTWorld.Row4;
                context.ObjectTWorld = newObjectToWorld;
                SceneInput.Eval(context);
            }

            return context;
        }
    }
}
