/*
  Copyright (C) 2013 Jolla Ltd.
  Contact: Thomas Perl <thomas.perl@jollamobile.com>
  All rights reserved.

  You may use this file under the terms of BSD license as follows:

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
	* Redistributions of source code must retain the above copyright
	  notice, this list of conditions and the following disclaimer.
	* Redistributions in binary form must reproduce the above copyright
	  notice, this list of conditions and the following disclaimer in the
	  documentation and/or other materials provided with the distribution.
	* Neither the name of the Jolla Ltd nor the
	  names of its contributors may be used to endorse or promote products
	  derived from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR
  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

import QtQuick 2.0
import Sailfish.Silica 1.0


Page
{
	id: page

	PageHeader
	{
        title: qsTr("7 days")
	}

	Column
	{
		anchors
		{
			centerIn: parent
		}

        spacing: 10

		Column
        {
            anchors
            {
                horizontalCenter: parent.horizontalCenter
            }

			Label
			{

			font
			{
				pixelSize: 20
			}

			text: "/ms"

			}

//            Rectangle
//            {
//                anchors.left: parent.left
//                anchors.leftMargin: 4
//                width: 1
//                height:	20
//                color: "white"
//            }
			Repeater
			{

                model: 13

				Column
				{
                    anchors
                    {
                        horizontalCenter: parent.horizontalCenter
                    }

                    Item
                    {
                        anchors.right: parent.right
                        width: 1
                        height:	45
                    }

					Rectangle
					{
                        anchors
                        {
                            horizontalCenter: parent.horizontalCenter
                        }

                        width: 500
						height: 1
						color: "white"
					}


				}

			}




//			Row
//			{
//				anchors.left: parent.left
//				anchors.leftMargin: 4
//				Rectangle
//				{
//					width: 50
//					height: 1
//					border.color: "white"
//					border.width: 5

//				}

//				Repeater
//				{
//					model: 9

//					Row
//					{
//						Rectangle
//						{
//						height: 6
//						width: 1
//						color: "white"
//						}

//						Rectangle
//						{
//						width: 50
//						height: 1
//						color: "white"
//						}

//					}
//				}
//			}

		}
        Label
        {
            anchors
            {
                horizontalCenter: parent.horizontalCenter
            }
            text: "Mon    Tue    Wed    Thu    Fri    Sat    Sun"

            Item
            {
                anchors.right: parent.right
                width: 1
                height:	40
            }

        }
		Label
		{
			anchors
			{
				horizontalCenter: parent.horizontalCenter
			}
            text: "avg: 0.00ms\nMoon wind speed over the last week"
		}

	}
}





