varying vec3 vPos;

uniform float time;

void main()
{
	vec2 uv = vPos.zy + vec2(0,-time*20.);
	if(time > 80)
		uv *= 0.01;
	else
		uv *= 0.01;

	float f = 0.;
	vec2 dir = vec2(0.2);
	f += clamp(pow(sin(uv.x * 3.145 * 2. + dir.y * time), 15.), 0., 1.);
	f += clamp(pow(sin(uv.y * 3.145 * 2. + dir.x * time), 15.), 0., 1.);
	f += clamp(pow(sin(uv.x * 3.145 * 10. + dir.y * time), 15.), 0., 1.);
	f += clamp(pow(sin(uv.y * 3.145 * 10. + dir.x * time), 15.), 0., 1.);
	if(time < 80)
		f *= (sin(time * 3.14 * 2)*0.5+0.5 + 0.4)*0.5;

	float depth = gl_FragCoord.z / gl_FragCoord.w;
	float fogFactor = smoothstep(20, 170, depth);

	gl_FragColor = vec4(mix(0.4*f*vec3(sin(time*2.)*0.5+0.5, sin(time)*0.5+0.5, 0.5), vec3(0), fogFactor), 1.0);

	if(time > 80)
		gl_FragColor *= 4;
	//float l = mod( vPos.z)

	//gl_FragColor = vec4(0.2,0.2,0.2, 1);
}
