attribute vec3 position;
attribute vec3 normal;
attribute vec2 uvCoord0;

uniform mat4 vpMat;
uniform mat4 mMat;
uniform mat3 normMat;

varying vec3 vNormal;
varying vec3 vWorldPos;
varying vec2 vTexCoord;

void main()
{
	vec4 modelPos = mMat * vec4(position, 1.0);
	gl_Position = vpMat * modelPos;
	vNormal = normMat * normal;
	vWorldPos = modelPos.xyz;
	vTexCoord = uvCoord0;
}
