varying vec2 vTexCoord;

uniform sampler2D srcTex;
uniform sampler2D dstTex;
uniform sampler2D lenseTex;
uniform vec2 texelSize;

uniform float exposure;

uniform float lenseFactor;

int numGhosts = 8;
float haloWidth = 0.45;
float distortionF = 0.6;
float ghostDispersal = 0.3;

vec4 textureColorShifted(in sampler2D tex, in vec2 texCoord, in vec2 direction, in vec3 distortion)
{
    return max(vec4(0), vec4(
        texture2D(tex, texCoord + direction * distortion.r).r,
        texture2D(tex, texCoord + direction * distortion.g).g,
        texture2D(tex, texCoord + direction * distortion.b).b,
        1) - 0.51) * 2.;
}

vec4 lenseFlare(in sampler2D tex, in vec2 uv, float brightness)
{
	vec2 newUv = -uv + vec2(1);
	vec3 distortion = vec3(-texelSize.x * distortionF, 0, texelSize.x * distortionF);
	vec2 ghostVec = (vec2(0.5) - newUv) * ghostDispersal;
    vec2 direction = normalize(ghostVec);
    vec4 result = vec4(0);
    for(int i = 0;i < numGhosts;++i)
    {
        vec2 offset = fract(newUv + ghostVec * float(i));
        float weight = length(vec2(0.5) - offset) / length(vec2(0.5));
        weight = pow(1 - weight, 10);

        result += textureColorShifted(tex, offset, direction, distortion) * weight;
    }

    vec2 haloVec = normalize(ghostVec) * haloWidth;
    float weight = length(vec2(0.5) - fract(newUv + haloVec)) / length(vec2(0.5));
    weight = pow(1 - weight, 5);
    result += textureColorShifted(tex, newUv + haloVec, direction, distortion) * weight;
	result += texture2D(lenseTex, uv) * lenseFactor;
	return result;
}

void main()
{
	//texture2D(baseTex, vTexCoord).rgb * 0.2
	vec3 baseColor = texture2D(srcTex, vTexCoord).rgb;
	vec3 texColor = lenseFlare(dstTex, vTexCoord, length(baseColor)).rgb
	+ baseColor
	+ texture2D(dstTex, vTexCoord).rgb ;

	texColor *= exposure;  // Hardcoded Exposure Adjustment
	/*vec3 x = max(vec3(0),texColor-0.004);
	vec3 retColor = (x*(6.2*x+.5))/(x*(6.2*x+1.7)+0.06);*/
//	if(length((gl_FragCoord.xy * texelSize - 0.5) * 2.0) > 1.0)
//		discard;

	gl_FragColor = vec4(pow(texColor,vec3(1/1.5)), 1.);
}
