#pragma once
#include <string>
#define _USE_MATH_DEFINES
#include "fake_qt.h"

class Player
{
  public:
    Player();
    Player(int id, int energy, int rotation, QPointF position, qreal velocityX, qreal velocityY);
    int id();
    void setId(int id);

    QString lastCommand();
    QString command();

    QString name();

    void addScore(int score) { m_score += score; }

    void doMove();

    void setAlive(bool alive);
    bool isAlive();

    void setRotation(int rotation);
    void rotate(int amount);
    int rotation() { return m_rotation; }

    int energy() { return m_energy; }
    void setEnergy(int energy);
    void decreaseEnergy(int amount);
    void increaseEnergy(int amount);
    void accelerate();

    QPointF position() const { return m_position; }
    void setPosition(QPointF position);

    void setVelocity(qreal vx, qreal vy);

    void setCommand(QString command);

    void turnLeft(int steps);
    void turnRight(int steps);

  private:
    int m_id;

    QString m_lastCommand;
    QString m_command;

    bool m_alive;
    int m_energy;
    int m_rotation;
    QPointF m_position;
    qreal m_velocityX;
    qreal m_velocityY;

    int m_score;
};
