import os

from distutils.core import setup, Extension
from distutils.sysconfig import get_config_vars

# To Build: python setup.py build_ext -i
# extra_compile_args = ["-O0"]  # gcc no optimazation
# extra_compile_args=["-Zi"]  # windows debug

compile_flags = []

if os.name == "nt":
    compile_flags.append('-EHsc')
else:
    compile_flags.append('-std=c++11')
    compile_flags.append('-g')
    (opt,) = get_config_vars('OPT')
    os.environ['OPT'] = " ".join(
        flag for flag in opt.split() if flag != '-Wstrict-prototypes'
    )


module1 = Extension('simuli',
            language='c++',
            include_dirs=['/usr/local/include'],
            sources=['src/main.cpp', 'src/player.cpp', 'src/missile.cpp', 'src/simulator.cpp', 'src/log.cpp'],
            extra_compile_args=compile_flags)


setup(name='PackageName',
            version='1.0',
            description='May the force be with you -Gandal',
            ext_modules=[module1])
