#version 330

uniform float time;
out vec4 colour;

vec2 circle(){
   float index = float(gl_VertexID);
   float x = sin(index / 2.707 + time / 10.0) * 0.85;
   float y = cos(index / 2.707 + time / 10.0) * 0.85;

   return vec2(x,y);
}

void main(){
   if(gl_VertexID > 17) return;

   vec2 vertex = circle();
   gl_PointSize = 25.0 * (sin(vertex.x * 45.0) + 2.0);
   gl_Position = vec4(vertex, 0.0, 1.0);
   colour = vec4(vertex.x, vertex.y, vertex.x, 1.0);
}