#version 330
layout (location = 0) out vec4 FragColor;

in vec2 texcoord;

uniform sampler2D rotimg;
uniform float time;
uniform float startrail;

void main(){
   float aspect = 16.0 / 9.0;
   float d = distance(texcoord, vec2(0.5));
   float angle = atan(texcoord.y - 0.5, texcoord.x * startrail - 0.5);
   vec2 newcoord;
   newcoord.x = sin(angle + time / 10.0) * d + 0.5;
   newcoord.y = cos(angle + time / 10.0) * d / aspect + 0.5;

   FragColor   = texture(rotimg, newcoord);
}